/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.addon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.holoeverywhere.addon.IAddon;
import org.holoeverywhere.addon.IAddonAttacher;
import org.holoeverywhere.addon.IAddonBase;

public final class IAddonBasicAttacher<V extends IAddonBase<Z>, Z>
implements IAddonAttacher<V> {
    private final Map<Class<? extends IAddon>, V> mAddons = new HashMap<Class<? extends IAddon>, V>();
    private final Set<V> mAddonsList = new TreeSet<V>(new AddonComparator());
    private boolean mLockAttaching = false;
    private Z mObject;

    public IAddonBasicAttacher(Z object) {
        this.mObject = object;
    }

    @Override
    public <T extends V> T addon(Class<? extends IAddon> clazz) {
        IAddonBase<Object> addon = (IAddonBase)this.mAddons.get(clazz);
        if (addon == null) {
            if (this.mLockAttaching) {
                throw new IAddonAttacher.AttachException(this.mObject, clazz);
            }
            addon = IAddon.obtain(clazz, this.mObject);
            if (addon == null) {
                return null;
            }
            this.mAddons.put(clazz, addon);
            this.mAddonsList.add(addon);
        }
        return (T)addon;
    }

    @Override
    public void addon(Collection<Class<? extends IAddon>> classes) {
        if (classes == null) {
            return;
        }
        for (Class<? extends IAddon> clazz : classes) {
            this.addon(clazz);
        }
    }

    @Override
    public <T extends V> T addon(String classname) {
        return this.addon(IAddon.makeAddonClass(classname));
    }

    public void inhert(Collection<Class<? extends IAddon>> sourceClasses) {
        if (sourceClasses == null || sourceClasses.size() == 0) {
            return;
        }
        ArrayList<Class<? extends IAddon>> classes = new ArrayList<Class<? extends IAddon>>();
        for (Class<? extends IAddon> clazz : sourceClasses) {
            IAddon.Addon addon;
            if (!clazz.isAnnotationPresent(IAddon.Addon.class) || !(addon = clazz.getAnnotation(IAddon.Addon.class)).inhert()) continue;
            classes.add(clazz);
        }
        this.addon(classes);
    }

    public void inhert(IAddonAttacher<?> attacher) {
        this.inhert(attacher == null ? null : attacher.obtainAddonsList());
    }

    @Override
    public boolean isAddonAttached(Class<? extends IAddon> clazz) {
        return this.mAddons.containsKey(clazz);
    }

    @Override
    public void lockAttaching() {
        this.mLockAttaching = true;
    }

    @Override
    public Collection<Class<? extends IAddon>> obtainAddonsList() {
        return new ArrayList<Class<? extends IAddon>>(this.mAddons.keySet());
    }

    @Override
    public boolean performAddonAction(IAddonAttacher.AddonCallback<V> callback) {
        if (this.mAddons.size() == 0) {
            return false;
        }
        callback.pre();
        boolean result = false;
        for (IAddonBase addon : this.mAddonsList) {
            result = callback.performAction(addon);
            if (!callback.mStopped) continue;
            return result;
        }
        return callback.post();
    }

    public void reset() {
        this.mAddons.clear();
        this.mAddonsList.clear();
        this.mLockAttaching = false;
    }

    private final class AddonComparator
    implements Comparator<V> {
        private AddonComparator() {
        }

        @Override
        public int compare(V lhs, V rhs) {
            int i2;
            int i1 = this.getWeight(((IAddonBase)lhs).getParent());
            return i1 > (i2 = this.getWeight(((IAddonBase)rhs).getParent())) ? 1 : (i1 < i2 ? -1 : 0);
        }

        private int getWeight(IAddon addon) {
            if (addon.getClass().isAnnotationPresent(IAddon.Addon.class)) {
                return addon.getClass().getAnnotation(IAddon.Addon.class).weight();
            }
            return -1;
        }
    }
}

