/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.addon;

import android.content.Context;
import java.util.Map;
import org.holoeverywhere.ThemeManager;
import org.holoeverywhere.app.ContextThemeWrapperPlus;
import org.holoeverywhere.util.WeaklyMap;

public class IAddonThemes
implements ThemeManager.ThemeSetter {
    private Map<Context, AddonThemeWrapper> mContexts;
    private int mDarkTheme = -1;
    private final ThemeResolver mDefaultThemeResolver = new ThemeResolver(){

        @Override
        public int resolveThemeForContext(Context context, int invalidTheme) {
            int theme = ThemeManager.getThemeType(context);
            if (theme == 0 && (theme = invalidTheme & ThemeManager.getThemeMask()) == 0) {
                theme = ThemeManager.DARK;
            }
            return ThemeManager.getThemeResource(theme |= IAddonThemes.this.mThemeFlag, false);
        }
    };
    private int mLightTheme = -1;
    private int mMixedTheme = -1;
    private final int mThemeFlag = ThemeManager.makeNewFlag();

    public IAddonThemes() {
        ThemeManager.registerThemeSetter(this);
    }

    public Context context(Context context) {
        return this.context(context, ThemeManager.DARK);
    }

    public Context context(Context context, int invalidTheme) {
        return this.context(context, invalidTheme, this.mDefaultThemeResolver);
    }

    public Context context(Context context, int invalidTheme, ThemeResolver themeResolver) {
        if (context instanceof AddonThemeWrapper) {
            return context;
        }
        AddonThemeWrapper wrapper = null;
        if (this.mContexts != null) {
            wrapper = this.mContexts.get(context);
        }
        if (wrapper == null) {
            int theme = themeResolver.resolveThemeForContext(context, invalidTheme);
            if (theme <= 0) {
                return null;
            }
            wrapper = new AddonThemeWrapper(context, theme);
            if (this.mContexts == null) {
                this.mContexts = new WeaklyMap<Context, AddonThemeWrapper>();
            }
            this.mContexts.put(context, wrapper);
        }
        return wrapper;
    }

    public int getDarkTheme() {
        return this.mDarkTheme;
    }

    public int getLightTheme() {
        return this.mLightTheme;
    }

    public int getMixedTheme() {
        return this.mMixedTheme;
    }

    public int getThemeFlag() {
        return this.mThemeFlag;
    }

    public void map(int darkTheme, int lightTheme, int mixedTheme) {
        this.mDarkTheme = darkTheme;
        this.mLightTheme = lightTheme;
        this.mMixedTheme = mixedTheme;
        this.setupThemes();
    }

    public void setDarkTheme(int darkTheme) {
        this.mDarkTheme = darkTheme;
        this.setupThemes();
    }

    public void setLightTheme(int lightTheme) {
        this.mLightTheme = lightTheme;
        this.setupThemes();
    }

    public void setMixedTheme(int mixedTheme) {
        this.mMixedTheme = mixedTheme;
        this.setupThemes();
    }

    @Override
    public void setupThemes() {
        ThemeManager.map(this.mThemeFlag | ThemeManager.DARK, this.mDarkTheme);
        ThemeManager.map(this.mThemeFlag | ThemeManager.LIGHT, this.mLightTheme);
        ThemeManager.map(this.mThemeFlag | ThemeManager.MIXED, this.mMixedTheme);
    }

    public Context unwrap(Context context) {
        if (context == null) {
            return null;
        }
        while (context instanceof AddonThemeWrapper) {
            context = ((AddonThemeWrapper)context).getBaseContext();
        }
        return context;
    }

    public static interface ThemeResolver {
        public int resolveThemeForContext(Context var1, int var2);
    }

    private static final class AddonThemeWrapper
    extends ContextThemeWrapperPlus {
        public AddonThemeWrapper(Context base, int themeres) {
            super(base, themeres);
        }
    }
}

