/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.TextView;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.app.Fragment;
import org.holoeverywhere.widget.GridView;

public class GridFragment
extends Fragment {
    private ListAdapter mAdapter;
    private CharSequence mEmptyText;
    private View mEmptyView;
    private GridView mGrid;
    private View mGridContainer;
    private boolean mGridShown;
    private final Handler mHandler = new Handler();
    private final AdapterView.OnItemClickListener mOnClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
            GridFragment.this.onGridItemClick((GridView)parent, v, position, id2);
        }
    };
    private View mProgressContainer;
    private final Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            GridFragment.this.mGrid.focusableViewAvailable((View)GridFragment.this.mGrid);
        }
    };
    private TextView mStandardEmptyView;

    private void ensureGrid() {
        if (this.mGrid != null) {
            return;
        }
        View root = this.getView();
        if (root == null) {
            throw new IllegalStateException("Content view not yet created");
        }
        if (root instanceof GridView) {
            this.mGrid = (GridView)root;
        } else {
            this.mStandardEmptyView = (TextView)root.findViewById(R.id.internalEmpty);
            if (this.mStandardEmptyView == null) {
                this.mEmptyView = root.findViewById(16908292);
            } else {
                this.mStandardEmptyView.setVisibility(8);
            }
            this.mProgressContainer = root.findViewById(R.id.progressContainer);
            this.mGridContainer = root.findViewById(R.id.listContainer);
            View rawGridVIew = root.findViewById(16908298);
            if (!(rawGridVIew instanceof GridView)) {
                if (rawGridVIew == null) {
                    throw new RuntimeException("Your content must have a GridVIew whose id attribute is 'android.R.id.list'");
                }
                throw new RuntimeException("Content has view with id attribute 'android.R.id.list' that is not a GridVIew class");
            }
            this.mGrid = (GridView)rawGridVIew;
            if (this.mEmptyView != null) {
                this.mGrid.setEmptyView(this.mEmptyView);
            } else if (this.mEmptyText != null) {
                this.mStandardEmptyView.setText(this.mEmptyText);
                this.mGrid.setEmptyView((View)this.mStandardEmptyView);
            }
        }
        this.mGridShown = true;
        this.mGrid.setOnItemClickListener(this.mOnClickListener);
        if (this.mAdapter != null) {
            ListAdapter adapter = this.mAdapter;
            this.mAdapter = null;
            this.setGridAdapter(adapter);
        } else if (this.mProgressContainer != null) {
            this.setGridShown(false, false);
        }
        this.mHandler.post(this.mRequestFocus);
    }

    protected View getEmptyView() {
        return this.mEmptyView;
    }

    public GridView getGridView() {
        this.ensureGrid();
        return this.mGrid;
    }

    public ListAdapter getListAdapter() {
        return this.mAdapter;
    }

    public long getSelectedItemId() {
        this.ensureGrid();
        return this.mGrid.getSelectedItemId();
    }

    public int getSelectedItemPosition() {
        this.ensureGrid();
        return this.mGrid.getSelectedItemPosition();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.grid_content, container, false);
    }

    @Override
    public void onDestroyView() {
        this.mHandler.removeCallbacks(this.mRequestFocus);
        this.mGrid = null;
        this.mGridShown = false;
        this.mGridContainer = null;
        this.mProgressContainer = null;
        this.mEmptyView = null;
        this.mStandardEmptyView = null;
        super.onDestroyView();
    }

    public void onGridItemClick(GridView l, View v, int position, long id2) {
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.ensureGrid();
    }

    public void setEmptyText(CharSequence text) {
        this.ensureGrid();
        if (this.mStandardEmptyView == null) {
            throw new IllegalStateException("Can't be used with a custom content view");
        }
        this.mStandardEmptyView.setText(text);
        if (this.mEmptyText == null) {
            this.mGrid.setEmptyView((View)this.mStandardEmptyView);
        }
        this.mEmptyText = text;
    }

    public void setGridAdapter(ListAdapter adapter) {
        boolean hadAdapter = this.mAdapter != null;
        this.mAdapter = adapter;
        if (this.mGrid != null) {
            this.mGrid.setAdapter(adapter);
            if (!this.mGridShown && !hadAdapter) {
                this.setGridShown(true, this.getView().getWindowToken() != null);
            }
        }
    }

    public void setGridShown(boolean shown) {
        this.setGridShown(shown, true);
    }

    private void setGridShown(boolean shown, boolean animate) {
        this.ensureGrid();
        if (this.mProgressContainer == null) {
            throw new IllegalStateException("Can't be used with a custom content view");
        }
        if (this.mGridShown == shown) {
            return;
        }
        this.mGridShown = shown;
        if (shown) {
            if (animate) {
                this.mProgressContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.fade_out));
                this.mGridContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.fade_in));
            } else {
                this.mProgressContainer.clearAnimation();
                this.mGridContainer.clearAnimation();
            }
            this.mProgressContainer.setVisibility(8);
            this.mGridContainer.setVisibility(0);
        } else {
            if (animate) {
                this.mProgressContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.fade_in));
                this.mGridContainer.startAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.fade_out));
            } else {
                this.mProgressContainer.clearAnimation();
                this.mGridContainer.clearAnimation();
            }
            this.mProgressContainer.setVisibility(0);
            this.mGridContainer.setVisibility(8);
        }
    }

    public void setGridShownNoAnimation(boolean shown) {
        this.setGridShown(shown, false);
    }

    public void setSelection(int position) {
        this.ensureGrid();
        this.mGrid.setSelection(position);
    }
}

