/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import org.holoeverywhere.R;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.widget.ListView;

public abstract class ListActivity
extends Activity {
    protected ListAdapter mAdapter;
    private boolean mFinishedStart = false;
    private Handler mHandler = new Handler();
    protected ListView mList;
    private AdapterView.OnItemClickListener mOnClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
            ListActivity.this.onListItemClick((ListView)parent, v, position, id2);
        }
    };
    private Runnable mRequestFocus = new Runnable(){

        @Override
        public void run() {
            ListActivity.this.mList.focusableViewAvailable((View)ListActivity.this.mList);
        }
    };

    private void ensureList() {
        if (this.mList != null) {
            return;
        }
        this.setContentView(R.layout.list_content);
    }

    public ListAdapter getListAdapter() {
        return this.mAdapter;
    }

    public ListView getListView() {
        this.ensureList();
        return this.mList;
    }

    public long getSelectedItemId() {
        return this.mList.getSelectedItemId();
    }

    public int getSelectedItemPosition() {
        return this.mList.getSelectedItemPosition();
    }

    @Override
    public void onContentChanged() {
        super.onContentChanged();
        View emptyView = this.findViewById(16908292);
        this.mList = (ListView)this.findViewById(16908298);
        if (this.mList == null) {
            throw new RuntimeException("Your content must have a ListView whose id attribute is 'android.R.id.list'");
        }
        if (emptyView != null) {
            this.mList.setEmptyView(emptyView);
        }
        this.mList.setOnItemClickListener(this.mOnClickListener);
        if (this.mFinishedStart) {
            this.setListAdapter(this.mAdapter);
        }
        this.mHandler.post(this.mRequestFocus);
        this.mFinishedStart = true;
    }

    @Override
    protected void onDestroy() {
        this.mHandler.removeCallbacks(this.mRequestFocus);
        super.onDestroy();
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
    }

    protected void onRestoreInstanceState(Bundle state) {
        this.ensureList();
        super.onRestoreInstanceState(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListAdapter(ListAdapter adapter) {
        ListActivity listActivity = this;
        synchronized (listActivity) {
            this.ensureList();
            this.mAdapter = adapter;
            this.mList.setAdapter(adapter);
        }
    }

    public void setSelection(int position) {
        this.mList.setSelection(position);
    }
}

