/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.PatternMatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.app.AlertActivity;
import org.holoeverywhere.internal.AlertController;
import org.holoeverywhere.widget.Button;
import org.holoeverywhere.widget.GridView;
import org.holoeverywhere.widget.TextView;

public abstract class ResolverActivity
extends AlertActivity
implements AdapterView.OnItemClickListener {
    public static final int FIRST_ISOLATED_UID = 99000;
    public static final int LAST_ISOLATED_UID = 99999;
    public static final int PER_USER_RANGE = 100000;
    private static final String TAG = "ResolverActivity";
    private ResolveListAdapter mAdapter;
    private Button mAlwaysButton;
    private boolean mAlwaysUseOption;
    private GridView mGrid;
    private int mIconDpi;
    private int mIconSize;
    private int mLastSelected = -1;
    private int mLaunchedFromUid;
    private int mMaxColumns;
    private Button mOnceButton;
    private PackageManager mPm;
    private boolean mShowExtended;

    public static final int getAppId(int uid) {
        return uid % 100000;
    }

    public static final boolean isIsolated(int uid) {
        if (uid > 0) {
            int appId = ResolverActivity.getAppId(uid);
            return appId >= 99000 && appId <= 99999;
        }
        return false;
    }

    public static final boolean isSameApp(int uid1, int uid2) {
        return ResolverActivity.getAppId(uid1) == ResolverActivity.getAppId(uid2);
    }

    public int checkComponentPermission(String permission, int uid, int owningUid, boolean exported) {
        if (uid == 0 || uid == 1000) {
            return 0;
        }
        if (ResolverActivity.isIsolated(uid)) {
            return -1;
        }
        if (owningUid >= 0 && ResolverActivity.isSameApp(uid, owningUid)) {
            return 0;
        }
        if (!exported) {
            Log.w((String)TAG, (String)("Permission denied: checkComponentPermission() owningUid=" + owningUid));
            return -1;
        }
        if (permission == null) {
            return 0;
        }
        return 0;
    }

    Drawable getIcon(Resources res, int resId) {
        try {
            if (Build.VERSION.SDK_INT >= 15) {
                return res.getDrawableForDensity(resId, this.mIconDpi);
            }
            return res.getDrawable(resId);
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
    }

    private int getLauncherLargeIconDensity(ActivityManager am) {
        int sw;
        if (Build.VERSION.SDK_INT >= 11) {
            return am.getLauncherLargeIconDensity();
        }
        Resources res = this.getResources();
        int density = res.getDisplayMetrics().densityDpi;
        Configuration conf = res.getConfiguration();
        if (Build.VERSION.SDK_INT >= 13) {
            sw = conf.smallestScreenWidthDp;
        } else {
            DisplayMetrics metrics = res.getDisplayMetrics();
            sw = (int)((float)Math.min(metrics.widthPixels, metrics.heightPixels) / metrics.density);
        }
        if (sw < 600) {
            return density;
        }
        switch (density) {
            case 120: {
                return 160;
            }
            case 160: {
                return 240;
            }
            case 213: {
                return 320;
            }
            case 240: {
                return 320;
            }
            case 320: {
                return 480;
            }
            case 480: {
                return 640;
            }
        }
        return (int)((float)density * 1.5f + 0.5f);
    }

    private int getLauncherLargeIconSize(ActivityManager am) {
        int sw;
        if (Build.VERSION.SDK_INT >= 11) {
            return am.getLauncherLargeIconSize();
        }
        Resources res = this.getResources();
        int size = res.getDimensionPixelSize(0x1050000);
        Configuration conf = res.getConfiguration();
        if (Build.VERSION.SDK_INT >= 13) {
            sw = conf.smallestScreenWidthDp;
        } else {
            DisplayMetrics metrics = res.getDisplayMetrics();
            sw = (int)((float)Math.min(metrics.widthPixels, metrics.heightPixels) / metrics.density);
        }
        if (sw < 600) {
            return size;
        }
        int density = res.getDisplayMetrics().densityDpi;
        switch (density) {
            case 120: {
                return size * 160 / 120;
            }
            case 160: {
                return size * 240 / 160;
            }
            case 213: {
                return size * 320 / 240;
            }
            case 240: {
                return size * 320 / 240;
            }
            case 320: {
                return size * 480 / 320;
            }
            case 480: {
                return size * 320 * 2 / 480;
            }
        }
        return (int)((float)size * 1.5f + 0.5f);
    }

    Drawable loadIconForResolveInfo(ResolveInfo ri) {
        try {
            Drawable dr;
            if (ri.resolvePackageName != null && ri.icon != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.resolvePackageName), ri.icon)) != null) {
                return dr;
            }
            int iconRes = ri.getIconResource();
            if (iconRes != 0 && (dr = this.getIcon(this.mPm.getResourcesForApplication(ri.activityInfo.packageName), iconRes)) != null) {
                return dr;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)"Couldn't find resources for package", (Throwable)e);
        }
        return ri.loadIcon(this.mPm);
    }

    private Intent makeMyIntent() {
        Intent intent = new Intent(this.getIntent());
        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
        return intent;
    }

    public void onButtonClick(View v) {
        int id2 = v.getId();
        this.startSelected(this.mGrid.getCheckedItemPosition(), id2 == R.id.button_always);
        this.dismiss();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        this.onCreate(savedInstanceState, this.makeMyIntent(), this.getResources().getText(R.string.whichApplication), null, null, true);
    }

    protected void onCreate(Bundle savedInstanceState, Intent intent, CharSequence title, Intent[] initialIntents, List<ResolveInfo> rList, boolean alwaysUseOption) {
        super.onCreate(savedInstanceState);
        try {
            this.mLaunchedFromUid = this.getPackageManager().getApplicationInfo((String)this.getPackageName(), (int)0).uid;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            this.mLaunchedFromUid = -1;
        }
        this.mPm = this.getPackageManager();
        this.mAlwaysUseOption = alwaysUseOption;
        this.mMaxColumns = this.getResources().getInteger(R.integer.config_maxResolverActivityColumns);
        intent.setComponent(null);
        AlertController.AlertParams ap = this.mAlertParams;
        ap.mTitle = title;
        ActivityManager am = (ActivityManager)this.getSystemService("activity");
        this.mIconDpi = this.getLauncherLargeIconDensity(am);
        this.mIconSize = this.getLauncherLargeIconSize(am);
        this.mAdapter = new ResolveListAdapter((Context)this, intent, initialIntents, rList, this.mLaunchedFromUid);
        int count = this.mAdapter.getCount();
        if (this.mLaunchedFromUid < 0 || ResolverActivity.isIsolated(this.mLaunchedFromUid)) {
            this.finish();
            return;
        }
        if (count > 1) {
            ap.mView = this.getLayoutInflater().inflate(R.layout.resolver_grid, null);
            this.mGrid = (GridView)ap.mView.findViewById(R.id.resolver_grid);
            this.mGrid.setAdapter((ListAdapter)this.mAdapter);
            this.mGrid.setOnItemClickListener(this);
            this.mGrid.setOnItemLongClickListener(new ItemLongClickListener());
            if (alwaysUseOption) {
                this.mGrid.setChoiceMode(1);
            }
            this.resizeGrid();
        } else {
            if (count == 1) {
                this.startActivity(this.mAdapter.intentForPosition(0));
                this.finish();
                return;
            }
            ap.mMessage = this.getResources().getText(R.string.noApplications);
        }
        this.setupAlert();
        if (alwaysUseOption) {
            ViewGroup buttonLayout = (ViewGroup)this.findViewById(R.id.button_bar);
            if (buttonLayout != null) {
                buttonLayout.setVisibility(0);
                this.mAlwaysButton = (Button)buttonLayout.findViewById(R.id.button_always);
                this.mOnceButton = (Button)buttonLayout.findViewById(R.id.button_once);
            } else {
                this.mAlwaysUseOption = false;
            }
        }
    }

    protected void onIntentSelected(ResolveInfo ri, Intent intent, boolean alwaysCheck) {
        if (alwaysCheck) {
            String mimeType;
            Set categories;
            IntentFilter filter = new IntentFilter();
            if (intent.getAction() != null) {
                filter.addAction(intent.getAction());
            }
            if ((categories = intent.getCategories()) != null) {
                for (String cat : categories) {
                    filter.addCategory(cat);
                }
            }
            filter.addCategory("android.intent.category.DEFAULT");
            int cat = ri.match & 0xFFF0000;
            Uri data = intent.getData();
            if (cat == 0x600000 && (mimeType = intent.resolveType((Context)this)) != null) {
                try {
                    filter.addDataType(mimeType);
                }
                catch (IntentFilter.MalformedMimeTypeException e) {
                    Log.w((String)TAG, (Throwable)e);
                    filter = null;
                }
            }
            if (data != null && data.getScheme() != null && (cat != 0x600000 || !"file".equals(data.getScheme()) && !"content".equals(data.getScheme()))) {
                Iterator pIt;
                filter.addDataScheme(data.getScheme());
                Iterator aIt = ri.filter.authoritiesIterator();
                if (aIt != null) {
                    while (aIt.hasNext()) {
                        IntentFilter.AuthorityEntry a = (IntentFilter.AuthorityEntry)aIt.next();
                        if (a.match(data) < 0) continue;
                        int port = a.getPort();
                        filter.addDataAuthority(a.getHost(), port >= 0 ? Integer.toString(port) : null);
                        break;
                    }
                }
                if ((pIt = ri.filter.pathsIterator()) != null) {
                    String path = data.getPath();
                    while (path != null && pIt.hasNext()) {
                        PatternMatcher p = (PatternMatcher)pIt.next();
                        if (!p.match(path)) continue;
                        filter.addDataPath(p.getPath(), p.getType());
                        break;
                    }
                }
            }
            if (filter != null) {
                int N = this.mAdapter.mList.size();
                ComponentName[] set = new ComponentName[N];
                int bestMatch = 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo r = ((DisplayResolveInfo)((ResolveListAdapter)this.mAdapter).mList.get((int)i)).ri;
                    set[i] = new ComponentName(r.activityInfo.packageName, r.activityInfo.name);
                    if (r.match <= bestMatch) continue;
                    bestMatch = r.match;
                }
                try {
                    this.getPackageManager().addPreferredActivity(filter, bestMatch, set, intent.getComponent());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (intent != null) {
            this.startActivity(intent);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        boolean hasValidSelection;
        int checkedPos = this.mGrid.getCheckedItemPosition();
        boolean bl = hasValidSelection = checkedPos != -1;
        if (this.mAlwaysUseOption && (!hasValidSelection || this.mLastSelected != checkedPos)) {
            this.mAlwaysButton.setEnabled(hasValidSelection);
            this.mOnceButton.setEnabled(hasValidSelection);
            if (hasValidSelection) {
                this.mGrid.smoothScrollToPosition(checkedPos);
            }
            this.mLastSelected = checkedPos;
        } else {
            this.startSelected(position, false);
        }
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        this.mAdapter.handlePackagesChanged();
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        if (this.mAlwaysUseOption) {
            int checkedPos = this.mGrid.getCheckedItemPosition();
            boolean enabled = checkedPos != -1;
            this.mLastSelected = checkedPos;
            this.mAlwaysButton.setEnabled(enabled);
            this.mOnceButton.setEnabled(enabled);
            if (enabled) {
                this.mGrid.setSelection(checkedPos);
            }
        }
    }

    @Override
    protected void onStop() {
        super.onStop();
        if ((this.getIntent().getFlags() & 0x10000000) != 0 && !this.isChangingConfigurations()) {
            this.finish();
        }
    }

    void resizeGrid() {
        int itemCount = this.mAdapter.getCount();
        this.mGrid.setNumColumns(Math.min(itemCount, this.mMaxColumns));
    }

    void showAppDetails(ResolveInfo ri) {
        Intent in = new Intent().setAction("android.settings.APPLICATION_DETAILS_SETTINGS").setData(Uri.fromParts((String)"package", (String)ri.activityInfo.packageName, null)).addFlags(524288);
        this.startActivity(in);
    }

    void startSelected(int which, boolean always) {
        ResolveInfo ri = this.mAdapter.resolveInfoForPosition(which);
        Intent intent = this.mAdapter.intentForPosition(which);
        this.onIntentSelected(ri, intent, always);
        this.finish();
    }

    private final class ResolveListAdapter
    extends BaseAdapter {
        private final List<ResolveInfo> mBaseResolveList;
        private List<ResolveInfo> mCurrentResolveList;
        private final LayoutInflater mInflater;
        private final Intent[] mInitialIntents;
        private final Intent mIntent;
        private final int mLaunchedFromUid;
        private List<DisplayResolveInfo> mList;

        public ResolveListAdapter(Context context, Intent intent, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid) {
            this.mIntent = new Intent(intent);
            this.mIntent.setComponent(null);
            this.mInitialIntents = initialIntents;
            this.mBaseResolveList = rList;
            this.mLaunchedFromUid = launchedFromUid;
            this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
            this.rebuildList();
        }

        private final void bindView(View view, DisplayResolveInfo info) {
            TextView text = (TextView)view.findViewById(16908308);
            TextView text2 = (TextView)view.findViewById(16908309);
            ImageView icon = (ImageView)view.findViewById(R.id.icon);
            text.setText(info.displayLabel);
            if (ResolverActivity.this.mShowExtended) {
                text2.setVisibility(0);
                text2.setText(info.extendedInfo);
            } else {
                text2.setVisibility(8);
            }
            if (info.displayIcon == null) {
                info.displayIcon = ResolverActivity.this.loadIconForResolveInfo(info.ri);
            }
            icon.setImageDrawable(info.displayIcon);
        }

        public int getCount() {
            return this.mList != null ? this.mList.size() : 0;
        }

        public Object getItem(int position) {
            return position;
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            View view;
            if (convertView == null) {
                view = this.mInflater.inflate(R.layout.resolve_list_item, parent, false);
                ImageView icon = (ImageView)view.findViewById(R.id.icon);
                ViewGroup.LayoutParams lp = icon.getLayoutParams();
                lp.width = lp.height = ResolverActivity.this.mIconSize;
            } else {
                view = convertView;
            }
            this.bindView(view, this.mList.get(position));
            return view;
        }

        public void handlePackagesChanged() {
            int newItemCount;
            int oldItemCount = this.getCount();
            this.rebuildList();
            this.notifyDataSetChanged();
            if (this.mList.size() == 0) {
                ResolverActivity.this.finish();
            }
            if ((newItemCount = this.getCount()) != oldItemCount) {
                ResolverActivity.this.resizeGrid();
            }
        }

        public Intent intentForPosition(int position) {
            if (this.mList == null) {
                return null;
            }
            DisplayResolveInfo dri = this.mList.get(position);
            Intent intent = new Intent(dri.origIntent != null ? dri.origIntent : this.mIntent);
            intent.addFlags(0x3000000);
            ActivityInfo ai = dri.ri.activityInfo;
            intent.setComponent(new ComponentName(ai.applicationInfo.packageName, ai.name));
            return intent;
        }

        private void processGroup(List<ResolveInfo> rList, int start, int end, ResolveInfo ro, CharSequence roLabel) {
            int num = end - start + 1;
            if (num == 1) {
                this.mList.add(new DisplayResolveInfo(ro, roLabel, null, null));
            } else {
                ResolverActivity.this.mShowExtended = true;
                boolean usePkg = false;
                CharSequence startApp = ro.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                if (startApp == null) {
                    usePkg = true;
                }
                if (!usePkg) {
                    HashSet<CharSequence> duplicates = new HashSet<CharSequence>();
                    duplicates.add(startApp);
                    for (int j = start + 1; j <= end; ++j) {
                        ResolveInfo jRi = rList.get(j);
                        CharSequence jApp = jRi.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm);
                        if (jApp == null || duplicates.contains(jApp)) {
                            usePkg = true;
                            break;
                        }
                        duplicates.add(jApp);
                    }
                    duplicates.clear();
                }
                for (int k = start; k <= end; ++k) {
                    ResolveInfo add = rList.get(k);
                    if (usePkg) {
                        this.mList.add(new DisplayResolveInfo(add, roLabel, add.activityInfo.packageName, null));
                        continue;
                    }
                    this.mList.add(new DisplayResolveInfo(add, roLabel, add.activityInfo.applicationInfo.loadLabel(ResolverActivity.this.mPm), null));
                }
            }
        }

        private void rebuildList() {
            int N;
            if (this.mBaseResolveList != null) {
                this.mCurrentResolveList = this.mBaseResolveList;
            } else {
                this.mCurrentResolveList = ResolverActivity.this.mPm.queryIntentActivities(this.mIntent, 0x10000 | (ResolverActivity.this.mAlwaysUseOption ? 64 : 0));
                if (this.mCurrentResolveList != null) {
                    for (int i = this.mCurrentResolveList.size() - 1; i >= 0; --i) {
                        ActivityInfo ai = this.mCurrentResolveList.get((int)i).activityInfo;
                        int granted = ResolverActivity.this.checkComponentPermission(ai.permission, this.mLaunchedFromUid, ai.applicationInfo.uid, ai.exported);
                        if (granted == 0) continue;
                        this.mCurrentResolveList.remove(i);
                    }
                }
            }
            if (this.mCurrentResolveList != null && (N = this.mCurrentResolveList.size()) > 0) {
                ResolveInfo r0 = this.mCurrentResolveList.get(0);
                for (int i = 1; i < N; ++i) {
                    ResolveInfo ri = this.mCurrentResolveList.get(i);
                    if (r0.priority == ri.priority && r0.isDefault == ri.isDefault) continue;
                    while (i < N) {
                        this.mCurrentResolveList.remove(i);
                        --N;
                    }
                }
                if (N > 1) {
                    ResolveInfo.DisplayNameComparator rComparator = new ResolveInfo.DisplayNameComparator(ResolverActivity.this.mPm);
                    Collections.sort(this.mCurrentResolveList, rComparator);
                }
                this.mList = new ArrayList<DisplayResolveInfo>();
                if (this.mInitialIntents != null) {
                    for (Intent ii : this.mInitialIntents) {
                        if (ii == null) continue;
                        ActivityInfo ai = ii.resolveActivityInfo(ResolverActivity.this.getPackageManager(), 0);
                        if (ai == null) {
                            Log.w((String)ResolverActivity.TAG, (String)("No activity found for " + ii));
                            continue;
                        }
                        ResolveInfo ri = new ResolveInfo();
                        ri.activityInfo = ai;
                        if (ii instanceof LabeledIntent) {
                            LabeledIntent li = (LabeledIntent)ii;
                            ri.resolvePackageName = li.getSourcePackage();
                            ri.labelRes = li.getLabelResource();
                            ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                            ri.icon = li.getIconResource();
                        }
                        this.mList.add(new DisplayResolveInfo(ri, ri.loadLabel(ResolverActivity.this.getPackageManager()), null, ii));
                    }
                }
                r0 = this.mCurrentResolveList.get(0);
                int start = 0;
                CharSequence r0Label = r0.loadLabel(ResolverActivity.this.mPm);
                ResolverActivity.this.mShowExtended = false;
                for (int i = 1; i < N; ++i) {
                    ResolveInfo ri;
                    CharSequence riLabel;
                    if (r0Label == null) {
                        r0Label = r0.activityInfo.packageName;
                    }
                    if ((riLabel = (ri = this.mCurrentResolveList.get(i)).loadLabel(ResolverActivity.this.mPm)) == null) {
                        riLabel = ri.activityInfo.packageName;
                    }
                    if (riLabel.equals(r0Label)) continue;
                    this.processGroup(this.mCurrentResolveList, start, i - 1, r0, r0Label);
                    r0 = ri;
                    r0Label = riLabel;
                    start = i;
                }
                this.processGroup(this.mCurrentResolveList, start, N - 1, r0, r0Label);
            }
        }

        public ResolveInfo resolveInfoForPosition(int position) {
            if (this.mList == null) {
                return null;
            }
            return this.mList.get((int)position).ri;
        }
    }

    class ItemLongClickListener
    implements AdapterView.OnItemLongClickListener {
        ItemLongClickListener() {
        }

        public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
            ResolveInfo ri = ResolverActivity.this.mAdapter.resolveInfoForPosition(position);
            ResolverActivity.this.showAppDetails(ri);
            return true;
        }
    }

    private final class DisplayResolveInfo {
        Drawable displayIcon;
        CharSequence displayLabel;
        CharSequence extendedInfo;
        Intent origIntent;
        ResolveInfo ri;

        DisplayResolveInfo(ResolveInfo pri, CharSequence pLabel, CharSequence pInfo, Intent pOrigIntent) {
            this.ri = pri;
            this.displayLabel = pLabel;
            this.extendedInfo = pInfo;
            this.origIntent = pOrigIntent;
        }
    }
}

