/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.app;

import android.os.Bundle;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.view.ViewGroup;
import com.actionbarsherlock.app.ActionBar;
import java.util.ArrayList;
import java.util.List;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.app.Fragment;
import org.holoeverywhere.app.TabSwipeInterface;

public abstract class TabSwipeFragment
extends Fragment
implements TabSwipeInterface<TabInfo> {
    private TabSwipeAdapter mAdapter;
    private int mCustomLayout = -1;
    private TabSwipeInterface.OnTabSelectedListener mOnTabSelectedListener;
    private int mPrevNavigationMode = 0;
    private boolean mSmoothScroll = true;
    private List<TabInfo> mTabs = new ArrayList<TabInfo>();
    private ViewPager mViewPager;

    @Override
    public TabInfo addTab(CharSequence title, Class<? extends Fragment> fragmentClass) {
        return this.addTab(title, (Class)fragmentClass, (Bundle)null);
    }

    @Override
    public TabInfo addTab(CharSequence title, Class<? extends Fragment> fragmentClass, Bundle fragmentArguments) {
        TabInfo info = new TabInfo();
        info.title = title;
        info.fragmentClass = fragmentClass;
        info.fragmentArguments = fragmentArguments;
        return this.addTab(info);
    }

    @Override
    public TabInfo addTab(int title, Class<? extends Fragment> fragmentClass) {
        return this.addTab(this.getText(title), (Class)fragmentClass, (Bundle)null);
    }

    @Override
    public TabInfo addTab(int title, Class<? extends Fragment> fragmentClass, Bundle fragmentArguments) {
        return this.addTab(this.getText(title), (Class)fragmentClass, fragmentArguments);
    }

    @Override
    public TabInfo addTab(TabInfo tabInfo) {
        this.mTabs.add(tabInfo);
        this.getSupportActionBar().addTab(this.makeActionBarTab(tabInfo));
        this.notifyChanged();
        return tabInfo;
    }

    @Override
    public TabInfo addTab(TabInfo tabInfo, int position) {
        this.mTabs.add(position, tabInfo);
        this.getSupportActionBar().addTab(this.makeActionBarTab(tabInfo), position);
        this.notifyChanged();
        return tabInfo;
    }

    private void dispatchTabSelected(int position) {
        boolean notify = false;
        if (this.mViewPager.getCurrentItem() != position) {
            this.mViewPager.setCurrentItem(position, this.mSmoothScroll);
            notify = true;
        }
        if (this.getSupportActionBar().getSelectedNavigationIndex() != position) {
            this.getSupportActionBar().selectTab(this.getSupportActionBar().getTabAt(position));
            notify = true;
        }
        if (notify) {
            this.onTabSelected(position);
        }
    }

    @Override
    public TabSwipeInterface.OnTabSelectedListener getOnTabSelectedListener() {
        return this.mOnTabSelectedListener;
    }

    @Override
    public boolean isSmoothScroll() {
        return this.mSmoothScroll;
    }

    protected ActionBar.Tab makeActionBarTab(TabInfo tabInfo) {
        ActionBar.Tab tab = this.getSupportActionBar().newTab();
        tab.setText(tabInfo.title);
        tab.setTabListener(this.mAdapter);
        return tab;
    }

    private void notifyChanged() {
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(this.mCustomLayout > 0 ? this.mCustomLayout : R.layout.tab_swipe, container, false);
    }

    @Override
    public void onDestroyView() {
        this.getSupportActionBar().removeAllTabs();
        this.getSupportActionBar().setNavigationMode(this.mPrevNavigationMode);
        super.onDestroyView();
    }

    protected abstract void onHandleTabs();

    public void onTabSelected(int position) {
        if (this.mOnTabSelectedListener != null) {
            this.mOnTabSelectedListener.onTabSelected(position);
        }
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mViewPager = (ViewPager)view.findViewById(R.id.tabSwipePager);
        if (this.mViewPager == null) {
            throw new IllegalStateException("Add ViewPager to your custom layout with id @id/tabSwipePager");
        }
        if (this.getSupportActionBar().getTabCount() > 0) {
            throw new IllegalStateException("TabSwipeFragment doesn't support multitabbed fragments");
        }
        this.mAdapter = new TabSwipeAdapter();
        this.onHandleTabs();
        this.mViewPager.setAdapter((PagerAdapter)this.mAdapter);
        this.mViewPager.setOnPageChangeListener((ViewPager.OnPageChangeListener)this.mAdapter);
        this.mPrevNavigationMode = this.getSupportActionBar().getNavigationMode();
        this.getSupportActionBar().setNavigationMode(2);
    }

    @Override
    public void reloadTabs() {
        this.removeAllTabs();
        this.onHandleTabs();
    }

    @Override
    public void removeAllTabs() {
        this.getSupportActionBar().removeAllTabs();
        this.mTabs.clear();
        this.notifyChanged();
    }

    @Override
    public TabInfo removeTab(int position) {
        TabInfo tabInfo = this.mTabs.remove(position);
        this.getSupportActionBar().removeTabAt(position);
        this.notifyChanged();
        return tabInfo;
    }

    @Override
    public TabInfo removeTab(TabInfo tabInfo) {
        for (int i = 0; i < this.mTabs.size(); ++i) {
            if (this.mTabs.get(i) != tabInfo) continue;
            return this.removeTab(i);
        }
        return tabInfo;
    }

    @Override
    public void setCurrentTab(int position) {
        this.dispatchTabSelected(Math.max(0, Math.min(position, this.mTabs.size() - 1)));
    }

    @Override
    public void setCustomLayout(int customLayout) {
        this.mCustomLayout = customLayout;
    }

    @Override
    public void setOnTabSelectedListener(TabSwipeInterface.OnTabSelectedListener onTabSelectedListener) {
        this.mOnTabSelectedListener = onTabSelectedListener;
    }

    @Override
    public void setSmoothScroll(boolean smoothScroll) {
        this.mSmoothScroll = smoothScroll;
    }

    private final class TabSwipeAdapter
    extends FragmentStatePagerAdapter
    implements ViewPager.OnPageChangeListener,
    ActionBar.TabListener {
        public TabSwipeAdapter() {
            super(TabSwipeFragment.this.getChildFragmentManager());
        }

        public int getCount() {
            return TabSwipeFragment.this.mTabs.size();
        }

        public Fragment getItem(int position) {
            TabInfo info = (TabInfo)TabSwipeFragment.this.mTabs.get(position);
            return Fragment.instantiate(info.fragmentClass, info.fragmentArguments);
        }

        public void onPageScrolled(int position, float percent, int pixels) {
        }

        public void onPageScrollStateChanged(int scrollState) {
        }

        public void onPageSelected(int position) {
            TabSwipeFragment.this.dispatchTabSelected(position);
        }

        @Override
        public void onTabReselected(ActionBar.Tab tab, FragmentTransaction ft) {
        }

        @Override
        public void onTabSelected(ActionBar.Tab tab, FragmentTransaction ft) {
            TabSwipeFragment.this.dispatchTabSelected(tab.getPosition());
        }

        @Override
        public void onTabUnselected(ActionBar.Tab tab, FragmentTransaction ft) {
        }
    }

    public static class TabInfo
    implements TabSwipeInterface.TabInfo {
        public Bundle fragmentArguments;
        public Class<? extends Fragment> fragmentClass;
        public CharSequence title;

        @Override
        public Bundle getFragmentArguments() {
            return this.fragmentArguments;
        }

        @Override
        public Class<? extends Fragment> getFragmentClass() {
            return this.fragmentClass;
        }

        @Override
        public CharSequence getTitle() {
            return this.title;
        }

        @Override
        public void setFragmentArguments(Bundle fragmentArguments) {
            this.fragmentArguments = fragmentArguments;
        }

        @Override
        public void setFragmentClass(Class<? extends Fragment> fragmentClass) {
            this.fragmentClass = fragmentClass;
        }

        @Override
        public void setTitle(CharSequence title) {
            this.title = title;
        }
    }
}

