/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.drawable;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import java.io.IOException;
import org.holoeverywhere.R;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RotateDrawable
extends Drawable
implements Drawable.Callback {
    private static final float MAX_LEVEL = 10000.0f;
    private boolean mMutated;
    private RotateState mState;

    public RotateDrawable() {
        this(null, null);
    }

    private RotateDrawable(RotateState rotateState, Resources res) {
        this.mState = new RotateState(rotateState, this, res);
    }

    public void draw(Canvas canvas) {
        int saveCount = canvas.save();
        Rect bounds = this.mState.mDrawable.getBounds();
        int w = bounds.right - bounds.left;
        int h = bounds.bottom - bounds.top;
        RotateState st = this.mState;
        float px = st.mPivotXRel ? (float)w * st.mPivotX : st.mPivotX;
        float py = st.mPivotYRel ? (float)h * st.mPivotY : st.mPivotY;
        canvas.rotate(st.mCurrentDegrees, px + (float)bounds.left, py + (float)bounds.top);
        st.mDrawable.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    public int getChangingConfigurations() {
        return super.getChangingConfigurations() | this.mState.mChangingConfigurations | this.mState.mDrawable.getChangingConfigurations();
    }

    public Drawable.ConstantState getConstantState() {
        if (this.mState.canConstantState()) {
            this.mState.mChangingConfigurations = this.getChangingConfigurations();
            return this.mState;
        }
        return null;
    }

    public Drawable getDrawable() {
        return this.mState.mDrawable;
    }

    public int getIntrinsicHeight() {
        return this.mState.mDrawable.getIntrinsicHeight();
    }

    public int getIntrinsicWidth() {
        return this.mState.mDrawable.getIntrinsicWidth();
    }

    public int getOpacity() {
        return this.mState.mDrawable.getOpacity();
    }

    public boolean getPadding(Rect padding) {
        return this.mState.mDrawable.getPadding(padding);
    }

    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        float pivotY;
        boolean pivotYRel;
        float pivotX;
        boolean pivotXRel;
        super.inflate(r, parser, attrs);
        TypedArray a = r.obtainAttributes(attrs, R.styleable.RotateDrawable);
        super.setVisible(a.getBoolean(0, true), false);
        TypedValue tv = a.peekValue(4);
        if (tv == null) {
            pivotXRel = true;
            pivotX = 0.5f;
        } else {
            pivotXRel = tv.type == 6;
            pivotX = pivotXRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        tv = a.peekValue(5);
        if (tv == null) {
            pivotYRel = true;
            pivotY = 0.5f;
        } else {
            pivotYRel = tv.type == 6;
            pivotY = pivotYRel ? tv.getFraction(1.0f, 1.0f) : tv.getFloat();
        }
        float fromDegrees = a.getFloat(2, 0.0f);
        float toDegrees = a.getFloat(3, 360.0f);
        int res = a.getResourceId(1, 0);
        Drawable drawable2 = null;
        if (res > 0) {
            drawable2 = r.getDrawable(res);
        }
        a.recycle();
        int outerDepth = parser.getDepth();
        while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
            if (type != 2 || (drawable2 = Drawable.createFromXmlInner((Resources)r, (XmlPullParser)parser, (AttributeSet)attrs)) != null) continue;
            Log.w((String)"drawable", (String)("Bad element under <rotate>: " + parser.getName()));
        }
        if (drawable2 == null) {
            Log.w((String)"drawable", (String)"No drawable specified for <rotate>");
        }
        this.mState.mDrawable = drawable2;
        this.mState.mPivotXRel = pivotXRel;
        this.mState.mPivotX = pivotX;
        this.mState.mPivotYRel = pivotYRel;
        this.mState.mPivotY = pivotY;
        this.mState.mFromDegrees = this.mState.mCurrentDegrees = fromDegrees;
        this.mState.mToDegrees = toDegrees;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
        }
    }

    public void invalidateDrawable(Drawable who) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.invalidateDrawable((Drawable)this);
        }
    }

    public boolean isStateful() {
        return this.mState.mDrawable.isStateful();
    }

    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mState.mDrawable.mutate();
            this.mMutated = true;
        }
        return this;
    }

    protected void onBoundsChange(Rect bounds) {
        this.mState.mDrawable.setBounds(bounds.left, bounds.top, bounds.right, bounds.bottom);
    }

    protected boolean onLevelChange(int level) {
        this.mState.mDrawable.setLevel(level);
        this.onBoundsChange(this.getBounds());
        this.mState.mCurrentDegrees = this.mState.mFromDegrees + (this.mState.mToDegrees - this.mState.mFromDegrees) * ((float)level / 10000.0f);
        this.invalidateSelf();
        return true;
    }

    protected boolean onStateChange(int[] state) {
        boolean changed = this.mState.mDrawable.setState(state);
        this.onBoundsChange(this.getBounds());
        return changed;
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.scheduleDrawable((Drawable)this, what, when);
        }
    }

    public void setAlpha(int alpha) {
        this.mState.mDrawable.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mState.mDrawable.setColorFilter(cf);
    }

    public boolean setVisible(boolean visible, boolean restart) {
        this.mState.mDrawable.setVisible(visible, restart);
        return super.setVisible(visible, restart);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        Drawable.Callback callback = this.getCallback();
        if (callback != null) {
            callback.unscheduleDrawable((Drawable)this, what);
        }
    }

    static final class RotateState
    extends Drawable.ConstantState {
        private boolean mCanConstantState;
        int mChangingConfigurations;
        private boolean mCheckedConstantState;
        float mCurrentDegrees;
        Drawable mDrawable;
        float mFromDegrees;
        float mPivotX;
        boolean mPivotXRel;
        float mPivotY;
        boolean mPivotYRel;
        float mToDegrees;

        public RotateState(RotateState source, RotateDrawable owner, Resources res) {
            if (source != null) {
                this.mDrawable = res != null ? source.mDrawable.getConstantState().newDrawable(res) : source.mDrawable.getConstantState().newDrawable();
                this.mDrawable.setCallback((Drawable.Callback)owner);
                this.mPivotXRel = source.mPivotXRel;
                this.mPivotX = source.mPivotX;
                this.mPivotYRel = source.mPivotYRel;
                this.mPivotY = source.mPivotY;
                this.mFromDegrees = this.mCurrentDegrees = source.mFromDegrees;
                this.mToDegrees = source.mToDegrees;
                this.mCheckedConstantState = true;
                this.mCanConstantState = true;
            }
        }

        public boolean canConstantState() {
            if (!this.mCheckedConstantState) {
                this.mCanConstantState = this.mDrawable.getConstantState() != null;
                this.mCheckedConstantState = true;
            }
            return this.mCanConstantState;
        }

        public int getChangingConfigurations() {
            return this.mChangingConfigurations;
        }

        public Drawable newDrawable() {
            return new RotateDrawable(this, null);
        }

        public Drawable newDrawable(Resources res) {
            return new RotateDrawable(this, res);
        }
    }
}

