/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.support.v4.widget.CursorAdapter;
import android.support.v4.widget.SimpleCursorAdapter;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ScrollView;
import java.lang.ref.WeakReference;
import org.holoeverywhere.LayoutInflater;
import org.holoeverywhere.R;
import org.holoeverywhere.widget.ArrayAdapter;
import org.holoeverywhere.widget.Button;
import org.holoeverywhere.widget.CheckedTextView;
import org.holoeverywhere.widget.FrameLayout;
import org.holoeverywhere.widget.LinearLayout;
import org.holoeverywhere.widget.ListView;
import org.holoeverywhere.widget.TextView;

public class AlertController {
    private ListAdapter mAdapter;
    private int mAlertDialogLayout;
    private int mButtonBehavior = 7;
    private View.OnClickListener mButtonHandler = new View.OnClickListener(){

        private boolean needToDismiss(int flag) {
            return (AlertController.this.mButtonBehavior & flag) == flag;
        }

        public void onClick(View v) {
            int button;
            if (v == AlertController.this.mButtonPositive) {
                button = -1;
            } else if (v == AlertController.this.mButtonNegative) {
                button = -2;
            } else if (v == AlertController.this.mButtonNeutral) {
                button = -3;
            } else {
                return;
            }
            boolean dismiss = false;
            switch (button) {
                case -1: {
                    this.send(AlertController.this.mButtonPositiveMessage);
                    dismiss = this.needToDismiss(4);
                    break;
                }
                case -2: {
                    this.send(AlertController.this.mButtonNegativeMessage);
                    dismiss = this.needToDismiss(1);
                    break;
                }
                case -3: {
                    this.send(AlertController.this.mButtonNeutralMessage);
                    dismiss = this.needToDismiss(2);
                }
            }
            if (dismiss) {
                AlertController.this.mHandler.obtainMessage(1, (Object)AlertController.this.mDialogInterface).sendToTarget();
            }
        }

        private void send(Message m) {
            if (m == null) {
                return;
            }
            Message.obtain((Message)m).sendToTarget();
        }
    };
    private Button mButtonNegative;
    private Message mButtonNegativeMessage;
    private CharSequence mButtonNegativeText;
    private Button mButtonNeutral;
    private Message mButtonNeutralMessage;
    private CharSequence mButtonNeutralText;
    private Button mButtonPositive;
    private Message mButtonPositiveMessage;
    private CharSequence mButtonPositiveText;
    private int mCheckedItem = -1;
    private final Context mContext;
    private View mCustomTitleView;
    private final AlertDecorViewInstaller mDecorViewInstaller;
    private final DialogInterface mDialogInterface;
    private boolean mForceInverseBackground;
    private Handler mHandler;
    private Drawable mIcon;
    private int mIconId = -1;
    private ImageView mIconView;
    private int mListItemLayout;
    private int mListLayout;
    private ListView mListView;
    private CharSequence mMessage;
    private TextView mMessageView;
    private int mMultiChoiceItemLayout;
    private ScrollView mScrollView;
    private int mSingleChoiceItemLayout;
    private CharSequence mTitle;
    private TextView mTitleView;
    private View mView;
    private int mViewSpacingBottom;
    private int mViewSpacingLeft;
    private int mViewSpacingRight;
    private boolean mViewSpacingSpecified = false;
    private int mViewSpacingTop;
    private final Window mWindow;

    static boolean canTextInput(View v) {
        if (v.onCheckIsTextEditor()) {
            return true;
        }
        if (!(v instanceof ViewGroup)) {
            return false;
        }
        ViewGroup vg = (ViewGroup)v;
        int i = vg.getChildCount();
        while (i > 0) {
            if (!AlertController.canTextInput(v = vg.getChildAt(--i))) continue;
            return true;
        }
        return false;
    }

    private static boolean shouldCenterSingleButton(Context context) {
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.alertDialogCenterButtons, outValue, true);
        return outValue.data != 0;
    }

    public AlertController(Context context, DialogInterface di, Window window) {
        this(context, di, window, null);
    }

    public AlertController(Context context, DialogInterface di, Window window, AlertDecorViewInstaller decorViewInstaller) {
        this.mDecorViewInstaller = decorViewInstaller;
        this.mContext = context;
        this.mDialogInterface = di;
        this.mWindow = window;
        this.mHandler = new ButtonHandler(di);
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.AlertDialog, R.attr.alertDialogStyle, R.style.Holo_AlertDialog);
        this.mAlertDialogLayout = a.getResourceId(10, R.layout.alert_dialog_holo);
        this.mListLayout = a.getResourceId(12, R.layout.select_dialog_holo);
        this.mMultiChoiceItemLayout = a.getResourceId(13, R.layout.select_dialog_multichoice_holo);
        this.mSingleChoiceItemLayout = a.getResourceId(15, R.layout.select_dialog_singlechoice_holo);
        this.mListItemLayout = a.getResourceId(11, R.layout.select_dialog_item_holo);
        a.recycle();
    }

    private void centerButton(Button button) {
        View rightSpacer;
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)button.getLayoutParams();
        params.gravity = 1;
        params.weight = 0.5f;
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        View leftSpacer = this.mWindow.findViewById(R.id.leftSpacer);
        if (leftSpacer != null) {
            leftSpacer.setVisibility(0);
        }
        if ((rightSpacer = this.mWindow.findViewById(R.id.rightSpacer)) != null) {
            rightSpacer.setVisibility(0);
        }
    }

    public Button getButton(int whichButton) {
        switch (whichButton) {
            case -1: {
                return this.mButtonPositive;
            }
            case -2: {
                return this.mButtonNegative;
            }
            case -3: {
                return this.mButtonNeutral;
            }
        }
        return null;
    }

    public ListView getListView() {
        return this.mListView;
    }

    public void installContent() {
        this.mWindow.requestFeature(1);
        if (this.mView == null || !AlertController.canTextInput(this.mView)) {
            this.mWindow.setFlags(131072, 131072);
        }
        if (this.mDecorViewInstaller == null) {
            this.mWindow.setContentView(LayoutInflater.inflate(this.mWindow.getContext(), this.mAlertDialogLayout));
        } else {
            this.mDecorViewInstaller.installDecorView(this.mContext, this.mAlertDialogLayout);
        }
        this.setupView();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mScrollView != null && this.mScrollView.executeKeyEvent(event);
    }

    private void setBackground(LinearLayout topPanel, LinearLayout contentPanel, View customPanel, boolean hasButtons, TypedArray a, boolean hasTitle, View buttonPanel) {
        int fullDark = a.getResourceId(7, R.drawable.dialog_full_holo_dark);
        int topDark = a.getResourceId(17, R.drawable.dialog_top_holo_dark);
        int centerDark = a.getResourceId(4, R.drawable.dialog_middle_holo_dark);
        int bottomDark = a.getResourceId(1, R.drawable.dialog_bottom_holo_dark);
        int fullBright = a.getResourceId(6, R.drawable.dialog_full_holo_dark);
        int topBright = a.getResourceId(16, R.drawable.dialog_top_holo_dark);
        int centerBright = a.getResourceId(3, R.drawable.dialog_middle_holo_dark);
        int bottomBright = a.getResourceId(0, R.drawable.dialog_bottom_holo_dark);
        int bottomMedium = a.getResourceId(2, R.drawable.dialog_bottom_holo_dark);
        View[] views = new View[4];
        boolean[] light = new boolean[4];
        View lastView = null;
        boolean lastLight = false;
        int pos = 0;
        if (hasTitle) {
            views[pos] = topPanel;
            light[pos] = false;
            ++pos;
        }
        views[pos] = contentPanel.getVisibility() == 8 ? null : contentPanel;
        light[pos] = this.mListView != null;
        ++pos;
        if (customPanel != null) {
            views[pos] = customPanel;
            light[pos] = this.mForceInverseBackground;
            ++pos;
        }
        if (hasButtons) {
            views[pos] = buttonPanel;
            light[pos] = true;
        }
        boolean setView = false;
        for (pos = 0; pos < views.length; ++pos) {
            View v = views[pos];
            if (v == null) continue;
            if (lastView != null) {
                if (!setView) {
                    lastView.setBackgroundResource(lastLight ? topBright : topDark);
                } else {
                    lastView.setBackgroundResource(lastLight ? centerBright : centerDark);
                }
                setView = true;
            }
            lastView = v;
            lastLight = light[pos];
        }
        if (lastView != null) {
            if (setView) {
                lastView.setBackgroundResource(lastLight ? (hasButtons ? bottomMedium : bottomBright) : bottomDark);
            } else {
                lastView.setBackgroundResource(lastLight ? fullBright : fullDark);
            }
        }
        if (this.mListView != null && this.mAdapter != null) {
            this.mListView.setAdapter(this.mAdapter);
            if (this.mCheckedItem > -1) {
                this.mListView.setItemChecked(this.mCheckedItem, true);
                this.mListView.setSelection(this.mCheckedItem);
            }
        }
    }

    public void setButton(int whichButton, CharSequence text, DialogInterface.OnClickListener listener, Message msg) {
        if (msg == null && listener != null) {
            msg = this.mHandler.obtainMessage(whichButton, (Object)listener);
        }
        switch (whichButton) {
            case -1: {
                this.mButtonPositiveText = text;
                this.mButtonPositiveMessage = msg;
                break;
            }
            case -2: {
                this.mButtonNegativeText = text;
                this.mButtonNegativeMessage = msg;
                break;
            }
            case -3: {
                this.mButtonNeutralText = text;
                this.mButtonNeutralMessage = msg;
                break;
            }
            default: {
                throw new IllegalArgumentException("Button does not exist");
            }
        }
    }

    public void setButtonBehavior(int buttonBehavior) {
        this.mButtonBehavior = buttonBehavior;
    }

    public void setCustomTitle(View customTitleView) {
        this.mCustomTitleView = customTitleView;
    }

    public void setIcon(Drawable icon) {
        this.mIcon = icon;
        if (this.mIconView != null && this.mIcon != null) {
            this.mIconView.setImageDrawable(icon);
        }
    }

    public void setIcon(int resId) {
        this.mIconId = resId;
        if (this.mIconView != null) {
            if (resId > 0) {
                this.mIconView.setImageResource(this.mIconId);
            } else if (resId == 0) {
                this.mIconView.setVisibility(8);
            }
        }
    }

    public void setInverseBackgroundForced(boolean forceInverseBackground) {
        this.mForceInverseBackground = forceInverseBackground;
    }

    public void setMessage(CharSequence message) {
        this.mMessage = message;
        if (this.mMessageView != null) {
            this.mMessageView.setText(message);
        }
    }

    public void setTitle(CharSequence title) {
        this.mTitle = title;
        if (this.mTitleView != null) {
            this.mTitleView.setText(title);
        }
    }

    private boolean setupButtons() {
        int BIT_BUTTON_POSITIVE = 1;
        int BIT_BUTTON_NEGATIVE = 2;
        int BIT_BUTTON_NEUTRAL = 4;
        int whichButtons = 0;
        this.mButtonPositive = (Button)this.mWindow.findViewById(R.id.button1);
        this.mButtonPositive.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty((CharSequence)this.mButtonPositiveText)) {
            this.mButtonPositive.setVisibility(8);
        } else {
            this.mButtonPositive.setText(this.mButtonPositiveText);
            this.mButtonPositive.setVisibility(0);
            whichButtons |= BIT_BUTTON_POSITIVE;
        }
        this.mButtonNegative = (Button)this.mWindow.findViewById(R.id.button2);
        this.mButtonNegative.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty((CharSequence)this.mButtonNegativeText)) {
            this.mButtonNegative.setVisibility(8);
        } else {
            this.mButtonNegative.setText(this.mButtonNegativeText);
            this.mButtonNegative.setVisibility(0);
            whichButtons |= BIT_BUTTON_NEGATIVE;
        }
        this.mButtonNeutral = (Button)this.mWindow.findViewById(R.id.button3);
        this.mButtonNeutral.setOnClickListener(this.mButtonHandler);
        if (TextUtils.isEmpty((CharSequence)this.mButtonNeutralText)) {
            this.mButtonNeutral.setVisibility(8);
        } else {
            this.mButtonNeutral.setText(this.mButtonNeutralText);
            this.mButtonNeutral.setVisibility(0);
            whichButtons |= BIT_BUTTON_NEUTRAL;
        }
        if (AlertController.shouldCenterSingleButton(this.mContext)) {
            if (whichButtons == BIT_BUTTON_POSITIVE) {
                this.centerButton(this.mButtonPositive);
            } else if (whichButtons == BIT_BUTTON_NEGATIVE) {
                this.centerButton(this.mButtonNeutral);
            } else if (whichButtons == BIT_BUTTON_NEUTRAL) {
                this.centerButton(this.mButtonNeutral);
            }
        }
        return whichButtons != 0;
    }

    private void setupContent(LinearLayout contentPanel) {
        this.mScrollView = (ScrollView)this.mWindow.findViewById(R.id.scrollView);
        this.mScrollView.setFocusable(false);
        this.mMessageView = (TextView)this.mWindow.findViewById(R.id.message);
        if (this.mMessageView == null) {
            return;
        }
        if (this.mMessage != null) {
            this.mMessageView.setText(this.mMessage);
        } else {
            this.mMessageView.setVisibility(8);
            this.mScrollView.removeView((View)this.mMessageView);
            if (this.mListView != null) {
                contentPanel.removeView(this.mWindow.findViewById(R.id.scrollView));
                contentPanel.addView((View)this.mListView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
                contentPanel.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, 0, 1.0f));
            } else {
                contentPanel.setVisibility(8);
            }
        }
    }

    private boolean setupTitle(LinearLayout topPanel) {
        boolean hasTitle = true;
        if (this.mCustomTitleView != null) {
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
            topPanel.addView(this.mCustomTitleView, 0, (ViewGroup.LayoutParams)lp);
            View titleTemplate = this.mWindow.findViewById(R.id.title_template);
            titleTemplate.setVisibility(8);
        } else {
            boolean hasTextTitle = !TextUtils.isEmpty((CharSequence)this.mTitle);
            this.mIconView = (ImageView)this.mWindow.findViewById(R.id.icon);
            if (hasTextTitle) {
                this.mTitleView = (TextView)this.mWindow.findViewById(R.id.alertTitle);
                this.mTitleView.setText(this.mTitle);
                if (this.mIconId > 0) {
                    this.mIconView.setImageResource(this.mIconId);
                } else if (this.mIcon != null) {
                    this.mIconView.setImageDrawable(this.mIcon);
                } else if (this.mIconId == 0) {
                    this.mTitleView.setPadding(this.mIconView.getPaddingLeft(), this.mIconView.getPaddingTop(), this.mIconView.getPaddingRight(), this.mIconView.getPaddingBottom());
                    this.mIconView.setVisibility(8);
                }
            } else {
                View titleTemplate = this.mWindow.findViewById(R.id.title_template);
                titleTemplate.setVisibility(8);
                this.mIconView.setVisibility(8);
                topPanel.setVisibility(8);
                hasTitle = false;
            }
        }
        return hasTitle;
    }

    private void setupView() {
        LinearLayout contentPanel = (LinearLayout)this.mWindow.findViewById(R.id.contentPanel);
        this.setupContent(contentPanel);
        boolean hasButtons = this.setupButtons();
        LinearLayout topPanel = (LinearLayout)this.mWindow.findViewById(R.id.topPanel);
        TypedArray a = this.mContext.obtainStyledAttributes(null, R.styleable.AlertDialog, R.attr.alertDialogStyle, R.style.Holo_AlertDialog);
        boolean hasTitle = this.setupTitle(topPanel);
        View buttonPanel = this.mWindow.findViewById(R.id.buttonPanel);
        if (!hasButtons) {
            buttonPanel.setVisibility(8);
        }
        FrameLayout customPanel = null;
        if (this.mView != null) {
            customPanel = (FrameLayout)this.mWindow.findViewById(R.id.customPanel);
            FrameLayout custom = (FrameLayout)this.mWindow.findViewById(R.id.custom);
            custom.addView(this.mView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            if (this.mViewSpacingSpecified) {
                custom.setPadding(this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
            }
            if (this.mListView != null) {
                ((LinearLayout.LayoutParams)customPanel.getLayoutParams()).weight = 0.0f;
            }
        } else {
            this.mWindow.findViewById(R.id.customPanel).setVisibility(8);
        }
        if (hasTitle) {
            View divider = null;
            divider = this.mMessage != null || this.mView != null || this.mListView != null ? this.mWindow.findViewById(R.id.titleDivider) : this.mWindow.findViewById(R.id.titleDividerTop);
            if (divider != null) {
                divider.setVisibility(0);
            }
        }
        this.setBackground(topPanel, contentPanel, (View)customPanel, hasButtons, a, hasTitle, buttonPanel);
        a.recycle();
    }

    public void setView(View view) {
        this.mView = view;
        this.mViewSpacingSpecified = false;
    }

    public void setView(View view, int viewSpacingLeft, int viewSpacingTop, int viewSpacingRight, int viewSpacingBottom) {
        this.mView = view;
        this.mViewSpacingSpecified = true;
        this.mViewSpacingLeft = viewSpacingLeft;
        this.mViewSpacingTop = viewSpacingTop;
        this.mViewSpacingRight = viewSpacingRight;
        this.mViewSpacingBottom = viewSpacingBottom;
    }

    private static final class ButtonHandler
    extends Handler {
        private static final int MSG_DISMISS_DIALOG = 1;
        private WeakReference<DialogInterface> mDialog;

        public ButtonHandler(DialogInterface dialog) {
            this.mDialog = new WeakReference<DialogInterface>(dialog);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case -3: 
                case -2: 
                case -1: {
                    ((DialogInterface.OnClickListener)msg.obj).onClick((DialogInterface)this.mDialog.get(), msg.what);
                    break;
                }
                case 1: {
                    ((DialogInterface)msg.obj).dismiss();
                }
            }
        }
    }

    public static class AlertParams {
        public ListAdapter mAdapter;
        public int mButtonBehavior = 7;
        public boolean mCancelable;
        public int mCheckedItem = -1;
        public boolean[] mCheckedItems;
        public final Context mContext;
        public Cursor mCursor;
        public View mCustomTitleView;
        public boolean mForceInverseBackground;
        public Drawable mIcon;
        public int mIconId = 0;
        public final LayoutInflater mInflater;
        public String mIsCheckedColumn;
        public boolean mIsMultiChoice;
        public boolean mIsSingleChoice;
        public CharSequence[] mItems;
        public String mLabelColumn;
        public CharSequence mMessage;
        public DialogInterface.OnClickListener mNegativeButtonListener;
        public CharSequence mNegativeButtonText;
        public DialogInterface.OnClickListener mNeutralButtonListener;
        public CharSequence mNeutralButtonText;
        public DialogInterface.OnCancelListener mOnCancelListener;
        public DialogInterface.OnMultiChoiceClickListener mOnCheckboxClickListener;
        public DialogInterface.OnClickListener mOnClickListener;
        public DialogInterface.OnDismissListener mOnDismissListener;
        public AdapterView.OnItemSelectedListener mOnItemSelectedListener;
        public DialogInterface.OnKeyListener mOnKeyListener;
        public OnPrepareListViewListener mOnPrepareListViewListener;
        public DialogInterface.OnClickListener mPositiveButtonListener;
        public CharSequence mPositiveButtonText;
        public int mTheme;
        public CharSequence mTitle;
        public View mView;
        public int mViewSpacingBottom;
        public int mViewSpacingLeft;
        public int mViewSpacingRight;
        public boolean mViewSpacingSpecified = false;
        public int mViewSpacingTop;

        public AlertParams(Context context) {
            this(context, 0);
        }

        public AlertParams(Context context, int theme) {
            this.mContext = context;
            this.mTheme = theme;
            this.mCancelable = true;
            this.mInflater = LayoutInflater.from(context);
        }

        public void apply(AlertController dialog) {
            if (this.mCustomTitleView != null) {
                dialog.setCustomTitle(this.mCustomTitleView);
            } else {
                if (this.mTitle != null) {
                    dialog.setTitle(this.mTitle);
                }
                if (this.mIcon != null) {
                    dialog.setIcon(this.mIcon);
                }
                if (this.mIconId >= 0) {
                    dialog.setIcon(this.mIconId);
                }
            }
            if (this.mMessage != null) {
                dialog.setMessage(this.mMessage);
            }
            if (this.mPositiveButtonText != null) {
                dialog.setButton(-1, this.mPositiveButtonText, this.mPositiveButtonListener, null);
            }
            if (this.mNegativeButtonText != null) {
                dialog.setButton(-2, this.mNegativeButtonText, this.mNegativeButtonListener, null);
            }
            if (this.mNeutralButtonText != null) {
                dialog.setButton(-3, this.mNeutralButtonText, this.mNeutralButtonListener, null);
            }
            dialog.setButtonBehavior(this.mButtonBehavior);
            if (this.mForceInverseBackground) {
                dialog.setInverseBackgroundForced(true);
            }
            if (this.mItems != null || this.mCursor != null || this.mAdapter != null) {
                this.createListView(dialog);
            }
            if (this.mView != null) {
                if (this.mViewSpacingSpecified) {
                    dialog.setView(this.mView, this.mViewSpacingLeft, this.mViewSpacingTop, this.mViewSpacingRight, this.mViewSpacingBottom);
                } else {
                    dialog.setView(this.mView);
                }
            }
        }

        private void createListView(final AlertController dialog) {
            Object adapter;
            final ListView listView = (ListView)this.mInflater.inflate(dialog.mListLayout, null);
            if (this.mIsMultiChoice) {
                adapter = this.mCursor == null ? new ArrayAdapter<CharSequence>(this.mContext, dialog.mMultiChoiceItemLayout, 16908308, this.mItems){

                    @Override
                    public View getView(int position, View convertView, ViewGroup parent) {
                        boolean isItemChecked;
                        View view = super.getView(position, convertView, parent);
                        if (AlertParams.this.mCheckedItems != null && (isItemChecked = AlertParams.this.mCheckedItems[position])) {
                            listView.setItemChecked(position, true);
                        }
                        return view;
                    }
                } : new CursorAdapter(this.mContext, this.mCursor, false){
                    private final int mIsCheckedIndex;
                    private final int mLabelIndex;
                    {
                        super(x0, x1, x2);
                        Cursor cursor = this.getCursor();
                        this.mLabelIndex = cursor.getColumnIndexOrThrow(AlertParams.this.mLabelColumn);
                        this.mIsCheckedIndex = cursor.getColumnIndexOrThrow(AlertParams.this.mIsCheckedColumn);
                    }

                    public void bindView(View view, Context context, Cursor cursor) {
                        CheckedTextView text = (CheckedTextView)view.findViewById(16908308);
                        text.setText(cursor.getString(this.mLabelIndex));
                        listView.setItemChecked(cursor.getPosition(), cursor.getInt(this.mIsCheckedIndex) == 1);
                    }

                    public View newView(Context context, Cursor cursor, ViewGroup parent) {
                        return AlertParams.this.mInflater.inflate(dialog.mMultiChoiceItemLayout, parent, false);
                    }
                };
            } else {
                int layout2;
                int n = layout2 = this.mIsSingleChoice ? dialog.mSingleChoiceItemLayout : dialog.mListItemLayout;
                adapter = this.mCursor == null ? (this.mAdapter != null ? this.mAdapter : new ArrayAdapter<CharSequence>(this.mContext, layout2, 16908308, this.mItems)) : new SimpleCursorAdapter(this.mContext, layout2, this.mCursor, new String[]{this.mLabelColumn}, new int[]{16908308}, 2);
            }
            if (this.mOnPrepareListViewListener != null) {
                this.mOnPrepareListViewListener.onPrepareListView(listView);
            }
            dialog.mAdapter = (ListAdapter)adapter;
            dialog.mCheckedItem = this.mCheckedItem;
            if (this.mOnClickListener != null) {
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                        AlertParams.this.mOnClickListener.onClick(dialog.mDialogInterface, position);
                        if (!AlertParams.this.mIsSingleChoice) {
                            dialog.mDialogInterface.dismiss();
                        }
                    }
                });
            } else if (this.mOnCheckboxClickListener != null) {
                listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
                        if (AlertParams.this.mCheckedItems != null) {
                            AlertParams.this.mCheckedItems[position] = listView.isItemChecked(position);
                        }
                        AlertParams.this.mOnCheckboxClickListener.onClick(dialog.mDialogInterface, position, listView.isItemChecked(position));
                    }
                });
            }
            if (this.mOnItemSelectedListener != null) {
                listView.setOnItemSelectedListener(this.mOnItemSelectedListener);
            }
            if (this.mIsSingleChoice) {
                listView.setChoiceMode(1);
            } else if (this.mIsMultiChoice) {
                listView.setChoiceMode(2);
            }
            dialog.mListView = listView;
        }

        public static interface OnPrepareListViewListener {
            public void onPrepareListView(ListView var1);
        }
    }

    public static interface AlertDecorViewInstaller {
        public void installDecorView(Context var1, int var2);
    }
}

