/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.internal;

import android.content.Context;
import android.content.res.XmlResourceParser;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class GenericInflater<T, P extends Parent<T>> {
    private static final HashMap<Class<?>, Constructor<?>> sConstructorMap = new HashMap();
    private ClassLoader mClassLoader;
    protected final Object[] mConstructorArgs = new Object[2];
    protected final Class<?>[] mConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private final Context mContext;
    private final List<Factory<T>> mFactoryList;
    private final List<String> mPackages = new ArrayList<String>();

    protected GenericInflater(Context context) {
        this.mContext = context;
        this.mFactoryList = new ArrayList<Factory<T>>();
    }

    protected GenericInflater(GenericInflater<T, P> original, Context newContext) {
        this.mContext = newContext;
        this.mFactoryList = new ArrayList<Factory<T>>(original.mFactoryList);
    }

    public void addFactory(Factory<T> factory) {
        this.mFactoryList.add(factory);
    }

    public abstract GenericInflater<T, P> cloneInContext(Context var1);

    public final T createItem(String name, String prefix, AttributeSet attrs) throws ClassNotFoundException, InflateException {
        if (prefix != null) {
            name = prefix + name;
        }
        Constructor<?> constructor = sConstructorMap.get(name);
        try {
            if (constructor == null) {
                if (this.mClassLoader == null) {
                    this.mClassLoader = this.getClassLoader();
                    if (this.mClassLoader == null) {
                        this.mClassLoader = this.mContext.getClassLoader();
                    }
                }
                Class<?> clazz = this.mClassLoader.loadClass(name);
                constructor = this.findConstructor(clazz);
                sConstructorMap.put(clazz, constructor);
            }
            return (T)constructor.newInstance(this.obtainConstructorArgs(name, attrs, constructor));
        }
        catch (NoSuchMethodException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + constructor.toString());
            ie.initCause((Throwable)e);
            throw ie;
        }
    }

    private final T createItemFromTag(XmlPullParser parser, String name, AttributeSet attrs) {
        try {
            T item = null;
            for (Factory<T> factory : this.mFactoryList) {
                try {
                    item = factory.onCreateItem(name, this.mContext, attrs);
                    if (item == null) continue;
                    break;
                }
                catch (Exception e) {
                }
            }
            if (item == null) {
                item = name.indexOf(46) < 0 ? (T)this.onCreateItem(name, attrs) : (T)this.createItem(name, null, attrs);
            }
            return item;
        }
        catch (InflateException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
        catch (Exception e) {
            InflateException ie = new InflateException(attrs.getPositionDescription() + ": Error inflating class " + name);
            ie.initCause((Throwable)e);
            throw ie;
        }
    }

    protected Constructor<?> findConstructor(Class<?> clazz) throws NoSuchMethodException {
        return clazz.getConstructor(this.mConstructorSignature);
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public Context getContext() {
        return this.mContext;
    }

    @Deprecated
    public final Factory<T> getFactory() {
        return this.getFactory(0);
    }

    public final Factory<T> getFactory(int position) {
        return this.mFactoryList.get(position);
    }

    public final int getFactoryCount() {
        return this.mFactoryList.size();
    }

    public T inflate(int resource) {
        return this.inflate(resource, null, false);
    }

    public T inflate(int resource, P root) {
        return this.inflate(resource, root, root != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T inflate(int resource, P root, boolean attachToRoot) {
        XmlResourceParser parser = this.getContext().getResources().getXml(resource);
        try {
            T t = this.inflate((XmlPullParser)parser, root, attachToRoot);
            return t;
        }
        finally {
            parser.close();
        }
    }

    public T inflate(XmlPullParser parser) {
        return this.inflate(parser, null, false);
    }

    public T inflate(XmlPullParser parser, P root) {
        return this.inflate(parser, root, root != null);
    }

    public synchronized T inflate(XmlPullParser parser, P root, boolean attachToRoot) {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        Object result = root;
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new InflateException(parser.getPositionDescription() + ": No start tag found!");
            }
            T xmlRoot = this.createItemFromTag(parser, parser.getName(), attrs);
            result = this.onMergeRoots(root, attachToRoot, (Parent)xmlRoot);
            this.rInflate(parser, result, attrs);
        }
        catch (InflateException e) {
            throw e;
        }
        catch (XmlPullParserException e) {
            InflateException ex = new InflateException(e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        catch (IOException e) {
            InflateException ex = new InflateException(parser.getPositionDescription() + ": " + e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        return (T)result;
    }

    protected Object[] obtainConstructorArgs(String name, AttributeSet attrs, Constructor<?> constructor) {
        Object[] args = this.mConstructorArgs;
        args[0] = this.mContext;
        args[1] = attrs;
        return args;
    }

    protected boolean onCreateCustomFromTag(XmlPullParser parser, T parent, AttributeSet attrs) throws XmlPullParserException {
        return false;
    }

    protected T onCreateItem(String name, AttributeSet attrs) throws ClassNotFoundException {
        Iterator<String> i$ = this.mPackages.iterator();
        if (i$.hasNext()) {
            String sPackage = i$.next();
            return this.createItem(name, sPackage + ".", attrs);
        }
        return null;
    }

    protected P onMergeRoots(P givenRoot, boolean attachToGivenRoot, P xmlRoot) {
        return xmlRoot;
    }

    public void registerPackage(String name) {
        if (!this.mPackages.contains(name = Package.getPackage(name).getName())) {
            this.mPackages.add(name);
        }
    }

    public void removeFactory(Factory<T> factory) {
        this.mFactoryList.remove(factory);
    }

    private void rInflate(XmlPullParser parser, T parent, AttributeSet attrs) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2 || this.onCreateCustomFromTag(parser, parent, attrs)) continue;
            String name = parser.getName();
            T item = this.createItemFromTag(parser, name, attrs);
            ((Parent)parent).addItemFromInflater(item);
            this.rInflate(parser, item, attrs);
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    public void setFactory(Factory<T> factory) {
        this.mFactoryList.add(0, factory);
    }

    public void unregisterPackage(String string2) {
        this.mPackages.remove(string2);
    }

    public static interface Parent<T> {
        public void addItemFromInflater(T var1);
    }

    public static interface Factory<T> {
        public T onCreateItem(String var1, Context var2, AttributeSet var3);
    }
}

