/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.widget.ExpandableListAdapter;
import org.holoeverywhere.widget.HeterogeneousExpandableList;

public abstract class BaseExpandableListAdapter
implements ExpandableListAdapter,
HeterogeneousExpandableList {
    private final DataSetObservable mDataSetObservable = new DataSetObservable();

    public boolean areAllItemsEnabled() {
        return true;
    }

    @Override
    public int getChildType(int groupPosition, int childPosition) {
        return 0;
    }

    @Override
    public int getChildTypeCount() {
        return 1;
    }

    public long getCombinedChildId(long groupId, long childId) {
        return Long.MIN_VALUE | (groupId & Integer.MAX_VALUE) << 32 | childId & 0xFFFFFFFFFFFFFFFFL;
    }

    public long getCombinedGroupId(long groupId) {
        return (groupId & Integer.MAX_VALUE) << 32;
    }

    @Override
    public int getGroupType(int groupPosition) {
        return 0;
    }

    @Override
    public int getGroupTypeCount() {
        return 1;
    }

    public boolean isEmpty() {
        return this.getGroupCount() == 0;
    }

    public void notifyDataSetChanged() {
        this.mDataSetObservable.notifyChanged();
    }

    public void notifyDataSetInvalidated() {
        this.mDataSetObservable.notifyInvalidated();
    }

    public void onGroupCollapsed(int groupPosition) {
    }

    public void onGroupExpanded(int groupPosition) {
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }
}

