/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.AdapterView;
import android.widget.ExpandableListAdapter;
import android.widget.ListAdapter;
import java.util.ArrayList;
import org.holoeverywhere.R;
import org.holoeverywhere.widget.ExpandableListConnector;
import org.holoeverywhere.widget.ExpandableListPosition;
import org.holoeverywhere.widget.ListView;

public class ExpandableListView
extends ListView {
    public static final int CHILD_INDICATOR_INHERIT = -1;
    private static final int[] CHILD_LAST_STATE_SET = new int[]{16842918};
    private static final int[] EMPTY_STATE_SET = new int[0];
    private static final int[] GROUP_EMPTY_STATE_SET = new int[]{16842921};
    private static final int[] GROUP_EXPANDED_EMPTY_STATE_SET = new int[]{16842920, 16842921};
    private static final int[] GROUP_EXPANDED_STATE_SET = new int[]{16842920};
    private static final int[][] GROUP_STATE_SETS = new int[][]{EMPTY_STATE_SET, GROUP_EXPANDED_STATE_SET, GROUP_EMPTY_STATE_SET, GROUP_EXPANDED_EMPTY_STATE_SET};
    private static final long PACKED_POSITION_INT_MASK_CHILD = -1L;
    private static final long PACKED_POSITION_INT_MASK_GROUP = Integer.MAX_VALUE;
    private static final long PACKED_POSITION_MASK_CHILD = 0xFFFFFFFFL;
    private static final long PACKED_POSITION_MASK_GROUP = 0x7FFFFFFF00000000L;
    private static final long PACKED_POSITION_MASK_TYPE = Long.MIN_VALUE;
    private static final long PACKED_POSITION_SHIFT_GROUP = 32L;
    private static final long PACKED_POSITION_SHIFT_TYPE = 63L;
    public static final int PACKED_POSITION_TYPE_CHILD = 1;
    public static final int PACKED_POSITION_TYPE_GROUP = 0;
    public static final int PACKED_POSITION_TYPE_NULL = 2;
    public static final long PACKED_POSITION_VALUE_NULL = 0xFFFFFFFFL;
    private ExpandableListAdapter mAdapter;
    private Drawable mChildDivider;
    private Drawable mChildIndicator;
    private int mChildIndicatorLeft;
    private int mChildIndicatorRight;
    private boolean mClipToPadding = false;
    private ExpandableListConnector mConnector;
    private Drawable mGroupIndicator;
    private int mIndicatorLeft;
    private final Rect mIndicatorRect = new Rect();
    private int mIndicatorRight;
    private OnChildClickListener mOnChildClickListener;
    private OnGroupClickListener mOnGroupClickListener;
    private OnGroupCollapseListener mOnGroupCollapseListener;
    private OnGroupExpandListener mOnGroupExpandListener;

    public static int getPackedPositionChild(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return -1;
        }
        if ((packedPosition & Long.MIN_VALUE) != Long.MIN_VALUE) {
            return -1;
        }
        return (int)(packedPosition & 0xFFFFFFFFL);
    }

    public static long getPackedPositionForChild(int groupPosition, int childPosition) {
        return Long.MIN_VALUE | ((long)groupPosition & Integer.MAX_VALUE) << 32 | (long)childPosition & 0xFFFFFFFFFFFFFFFFL;
    }

    public static long getPackedPositionForGroup(int groupPosition) {
        return ((long)groupPosition & Integer.MAX_VALUE) << 32;
    }

    public static int getPackedPositionGroup(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return -1;
        }
        return (int)((packedPosition & 0x7FFFFFFF00000000L) >> 32);
    }

    public static int getPackedPositionType(long packedPosition) {
        if (packedPosition == 0xFFFFFFFFL) {
            return 2;
        }
        return (packedPosition & Long.MIN_VALUE) == Long.MIN_VALUE ? 1 : 0;
    }

    public ExpandableListView(Context context) {
        this(context, null);
    }

    public ExpandableListView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842863);
    }

    public ExpandableListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ExpandableListView, defStyle, R.style.Holo_ExpandableListView);
        this.mGroupIndicator = a.getDrawable(0);
        this.mChildIndicator = a.getDrawable(1);
        this.mIndicatorLeft = a.getDimensionPixelSize(2, 0);
        this.mIndicatorRight = a.getDimensionPixelSize(3, 0);
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
        this.mChildIndicatorLeft = a.getDimensionPixelSize(4, -1);
        this.mChildIndicatorRight = a.getDimensionPixelSize(5, -1);
        this.mChildDivider = a.getDrawable(6);
        a.recycle();
    }

    public boolean collapseGroup(int groupPos) {
        boolean retValue = this.mConnector.collapseGroup(groupPos);
        if (this.mOnGroupCollapseListener != null) {
            this.mOnGroupCollapseListener.onGroupCollapse(groupPos);
        }
        return retValue;
    }

    @Override
    protected ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int flatListPosition, long id2) {
        if (this.isHeaderOrFooterPosition(flatListPosition)) {
            return super.createContextMenuInfo(view, flatListPosition, id2);
        }
        int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getUnflattenedPos(adjustedPosition);
        ExpandableListPosition pos = pm.position;
        id2 = this.getChildOrGroupId(pos);
        long packedPosition = pos.getPackedPosition();
        pm.recycle();
        return new ExpandableListContextMenuInfo(view, packedPosition, id2);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mChildIndicator == null && this.mGroupIndicator == null) {
            return;
        }
        int saveCount = 0;
        boolean clipToPadding = this.mClipToPadding;
        if (clipToPadding) {
            saveCount = canvas.save();
            int scrollX = this.getScrollX();
            int scrollY = this.getScrollY();
            canvas.clipRect(scrollX + this.getPaddingLeft(), scrollY + this.getPaddingTop(), scrollX + this.getRight() - this.getLeft() - this.getPaddingRight(), scrollY + this.getBottom() - this.getTop() - this.getPaddingBottom());
        }
        int headerViewsCount = this.getHeaderViewsCount();
        int lastChildFlPos = this.getCount() - this.getFooterViewsCount() - headerViewsCount - 1;
        int myB = this.getBottom();
        int lastItemType = -4;
        Rect indicatorRect = this.mIndicatorRect;
        int childCount = this.getChildCount();
        int i = 0;
        int childFlPos = this.getFirstVisiblePosition() - headerViewsCount;
        while (i < childCount) {
            if (childFlPos >= 0) {
                if (childFlPos > lastChildFlPos) break;
                View item = this.getChildAt(i);
                int t = item.getTop();
                int b = item.getBottom();
                if (b >= 0 && t <= myB) {
                    ExpandableListConnector.PositionMetadata pos = this.mConnector.getUnflattenedPos(childFlPos);
                    if (pos.position.type != lastItemType) {
                        if (pos.position.type == 1) {
                            indicatorRect.left = this.mChildIndicatorLeft == -1 ? this.mIndicatorLeft : this.mChildIndicatorLeft;
                            indicatorRect.right = this.mChildIndicatorRight == -1 ? this.mIndicatorRight : this.mChildIndicatorRight;
                        } else {
                            indicatorRect.left = this.mIndicatorLeft;
                            indicatorRect.right = this.mIndicatorRight;
                        }
                        indicatorRect.left += this.getPaddingLeft();
                        indicatorRect.right += this.getPaddingLeft();
                        lastItemType = pos.position.type;
                    }
                    if (indicatorRect.left != indicatorRect.right) {
                        if (this.isStackFromBottom()) {
                            indicatorRect.top = t;
                            indicatorRect.bottom = b;
                        } else {
                            indicatorRect.top = t;
                            indicatorRect.bottom = b;
                        }
                        Drawable indicator = this.getIndicator(pos);
                        if (indicator != null) {
                            indicator.setBounds(indicatorRect);
                            indicator.draw(canvas);
                        }
                    }
                    pos.recycle();
                }
            }
            ++i;
            ++childFlPos;
        }
        if (clipToPadding) {
            canvas.restoreToCount(saveCount);
        }
    }

    @Override
    void drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        int flatListPosition = childIndex + this.getFirstVisiblePosition();
        if (flatListPosition >= 0) {
            int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
            ExpandableListConnector.PositionMetadata pos = this.mConnector.getUnflattenedPos(adjustedPosition);
            if (pos.position.type == 1 || pos.isExpanded() && pos.groupMetadata.lastChildFlPos != pos.groupMetadata.flPos) {
                Drawable divider = this.mChildDivider;
                divider.setBounds(bounds);
                divider.draw(canvas);
                pos.recycle();
                return;
            }
            pos.recycle();
        }
        super.drawDivider(canvas, bounds, flatListPosition);
    }

    public boolean expandGroup(int groupPos) {
        return this.expandGroup(groupPos, false);
    }

    public boolean expandGroup(int groupPos, boolean animate) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtain(2, groupPos, -1, -1);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        boolean retValue = this.mConnector.expandGroup(pm);
        if (this.mOnGroupExpandListener != null) {
            this.mOnGroupExpandListener.onGroupExpand(groupPos);
        }
        if (animate && Build.VERSION.SDK_INT >= 8) {
            int groupFlatPos = pm.position.flatListPos;
            int shiftedGroupPosition = groupFlatPos + this.getHeaderViewsCount();
            this.smoothScrollToPosition(shiftedGroupPosition + this.mAdapter.getChildrenCount(groupPos), shiftedGroupPosition);
        }
        pm.recycle();
        return retValue;
    }

    private int getAbsoluteFlatPosition(int flatListPosition) {
        return flatListPosition + this.getHeaderViewsCount();
    }

    private long getChildOrGroupId(ExpandableListPosition position) {
        if (position.type == 1) {
            return this.mAdapter.getChildId(position.groupPos, position.childPos);
        }
        return this.mAdapter.getGroupId(position.groupPos);
    }

    public ExpandableListAdapter getExpandableListAdapter() {
        return this.mAdapter;
    }

    public long getExpandableListPosition(int flatListPosition) {
        if (this.isHeaderOrFooterPosition(flatListPosition)) {
            return 0xFFFFFFFFL;
        }
        int adjustedPosition = this.getFlatPositionForConnector(flatListPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getUnflattenedPos(adjustedPosition);
        long packedPos = pm.position.getPackedPosition();
        pm.recycle();
        return packedPos;
    }

    public int getFlatListPosition(long packedPosition) {
        ExpandableListPosition elPackedPos = ExpandableListPosition.obtainPosition(packedPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elPackedPos);
        elPackedPos.recycle();
        int flatListPosition = pm.position.flatListPos;
        pm.recycle();
        return this.getAbsoluteFlatPosition(flatListPosition);
    }

    private int getFlatPositionForConnector(int flatListPosition) {
        return flatListPosition - this.getHeaderViewsCount();
    }

    private Drawable getIndicator(ExpandableListConnector.PositionMetadata pos) {
        Drawable indicator;
        if (pos.position.type == 2) {
            indicator = this.mGroupIndicator;
            if (indicator != null && indicator.isStateful()) {
                boolean isEmpty = pos.groupMetadata == null || pos.groupMetadata.lastChildFlPos == pos.groupMetadata.flPos;
                int stateSetIndex = (pos.isExpanded() ? 1 : 0) | (isEmpty ? 2 : 0);
                indicator.setState(GROUP_STATE_SETS[stateSetIndex]);
            }
        } else {
            indicator = this.mChildIndicator;
            if (indicator != null && indicator.isStateful()) {
                int[] stateSet = pos.position.flatListPos == pos.groupMetadata.lastChildFlPos ? CHILD_LAST_STATE_SET : EMPTY_STATE_SET;
                indicator.setState(stateSet);
            }
        }
        return indicator;
    }

    public long getSelectedId() {
        long packedPos = this.getSelectedPosition();
        if (packedPos == 0xFFFFFFFFL) {
            return -1L;
        }
        int groupPos = ExpandableListView.getPackedPositionGroup(packedPos);
        if (ExpandableListView.getPackedPositionType(packedPos) == 0) {
            return this.mAdapter.getGroupId(groupPos);
        }
        return this.mAdapter.getChildId(groupPos, ExpandableListView.getPackedPositionChild(packedPos));
    }

    public long getSelectedPosition() {
        int selectedPos = this.getSelectedItemPosition();
        return this.getExpandableListPosition(selectedPos);
    }

    boolean handleItemClick(View v, int position, long id2) {
        boolean returnValue;
        ExpandableListConnector.PositionMetadata posMetadata = this.mConnector.getUnflattenedPos(position);
        id2 = this.getChildOrGroupId(posMetadata.position);
        if (posMetadata.position.type == 2) {
            if (this.mOnGroupClickListener != null && this.mOnGroupClickListener.onGroupClick(this, v, posMetadata.position.groupPos, id2)) {
                posMetadata.recycle();
                return true;
            }
            if (posMetadata.isExpanded()) {
                this.mConnector.collapseGroup(posMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupCollapseListener != null) {
                    this.mOnGroupCollapseListener.onGroupCollapse(posMetadata.position.groupPos);
                }
            } else {
                this.mConnector.expandGroup(posMetadata);
                this.playSoundEffect(0);
                if (this.mOnGroupExpandListener != null) {
                    this.mOnGroupExpandListener.onGroupExpand(posMetadata.position.groupPos);
                }
                if (Build.VERSION.SDK_INT >= 8) {
                    int groupPos = posMetadata.position.groupPos;
                    int groupFlatPos = posMetadata.position.flatListPos;
                    int shiftedGroupPosition = groupFlatPos + this.getHeaderViewsCount();
                    this.smoothScrollToPosition(shiftedGroupPosition + this.mAdapter.getChildrenCount(groupPos), shiftedGroupPosition);
                }
            }
            returnValue = true;
        } else {
            if (this.mOnChildClickListener != null) {
                this.playSoundEffect(0);
                return this.mOnChildClickListener.onChildClick(this, v, posMetadata.position.groupPos, posMetadata.position.childPos, id2);
            }
            returnValue = false;
        }
        posMetadata.recycle();
        return returnValue;
    }

    public boolean isGroupExpanded(int groupPosition) {
        return this.mConnector.isGroupExpanded(groupPosition);
    }

    private boolean isHeaderOrFooterPosition(int position) {
        int footerViewsStart = this.getCount() - this.getFooterViewsCount();
        return position < this.getHeaderViewsCount() || position >= footerViewsStart;
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName((CharSequence)ExpandableListView.class.getName());
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName((CharSequence)ExpandableListView.class.getName());
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.mConnector != null && ss.expandedGroupMetadataList != null) {
            this.mConnector.setExpandedGroupMetadataList(ss.expandedGroupMetadataList);
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.mConnector != null ? this.mConnector.getExpandedGroupMetadataList() : null);
    }

    @Override
    public boolean performItemClick(View v, int position, long id2) {
        if (this.isHeaderOrFooterPosition(position)) {
            return super.performItemClick(v, position, id2);
        }
        int adjustedPosition = this.getFlatPositionForConnector(position);
        return this.handleItemClick(v, adjustedPosition, id2);
    }

    public void setAdapter(ExpandableListAdapter adapter) {
        this.mAdapter = adapter;
        this.mConnector = adapter != null ? new ExpandableListConnector(adapter) : null;
        super.setAdapter((ListAdapter)this.mConnector);
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        throw new RuntimeException("For ExpandableListView, use setAdapter(ExpandableListAdapter) instead of setAdapter(ListAdapter)");
    }

    public void setChildDivider(Drawable childDivider) {
        this.mChildDivider = childDivider;
    }

    public void setChildIndicator(Drawable childIndicator) {
        this.mChildIndicator = childIndicator;
    }

    public void setChildIndicatorBounds(int left, int right) {
        this.mChildIndicatorLeft = left;
        this.mChildIndicatorRight = right;
    }

    public void setClipToPadding(boolean clipToPadding) {
        this.mClipToPadding = clipToPadding;
        super.setClipToPadding(this.mClipToPadding);
    }

    public void setGroupIndicator(Drawable groupIndicator) {
        this.mGroupIndicator = groupIndicator;
        if (this.mIndicatorRight == 0 && this.mGroupIndicator != null) {
            this.mIndicatorRight = this.mIndicatorLeft + this.mGroupIndicator.getIntrinsicWidth();
        }
    }

    public void setIndicatorBounds(int left, int right) {
        this.mIndicatorLeft = left;
        this.mIndicatorRight = right;
    }

    public void setOnChildClickListener(OnChildClickListener onChildClickListener) {
        this.mOnChildClickListener = onChildClickListener;
    }

    public void setOnGroupClickListener(OnGroupClickListener onGroupClickListener) {
        this.mOnGroupClickListener = onGroupClickListener;
    }

    public void setOnGroupCollapseListener(OnGroupCollapseListener onGroupCollapseListener) {
        this.mOnGroupCollapseListener = onGroupCollapseListener;
    }

    public void setOnGroupExpandListener(OnGroupExpandListener onGroupExpandListener) {
        this.mOnGroupExpandListener = onGroupExpandListener;
    }

    public void setOnItemClickListener(AdapterView.OnItemClickListener l) {
        super.setOnItemClickListener(l);
    }

    public boolean setSelectedChild(int groupPosition, int childPosition, boolean shouldExpandGroup) {
        ExpandableListPosition elChildPos = ExpandableListPosition.obtainChildPosition(groupPosition, childPosition);
        ExpandableListConnector.PositionMetadata flatChildPos = this.mConnector.getFlattenedPos(elChildPos);
        if (flatChildPos == null) {
            if (!shouldExpandGroup) {
                return false;
            }
            this.expandGroup(groupPosition);
            flatChildPos = this.mConnector.getFlattenedPos(elChildPos);
            if (flatChildPos == null) {
                throw new IllegalStateException("Could not find child");
            }
        }
        int absoluteFlatPosition = this.getAbsoluteFlatPosition(flatChildPos.position.flatListPos);
        super.setSelection(absoluteFlatPosition);
        elChildPos.recycle();
        flatChildPos.recycle();
        return true;
    }

    public void setSelectedGroup(int groupPosition) {
        ExpandableListPosition elGroupPos = ExpandableListPosition.obtainGroupPosition(groupPosition);
        ExpandableListConnector.PositionMetadata pm = this.mConnector.getFlattenedPos(elGroupPos);
        elGroupPos.recycle();
        int absoluteFlatPosition = this.getAbsoluteFlatPosition(pm.position.flatListPos);
        super.setSelection(absoluteFlatPosition);
        pm.recycle();
    }

    static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        ArrayList<ExpandableListConnector.GroupMetadata> expandedGroupMetadataList;

        private SavedState(Parcel in) {
            super(in.readParcelable(ListView.SavedState.class.getClassLoader()));
            this.expandedGroupMetadataList = new ArrayList();
            in.readList(this.expandedGroupMetadataList, ExpandableListConnector.class.getClassLoader());
        }

        SavedState(Parcelable superState, ArrayList<ExpandableListConnector.GroupMetadata> expandedGroupMetadataList) {
            super(superState);
            this.expandedGroupMetadataList = expandedGroupMetadataList;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeList(this.expandedGroupMetadataList);
        }
    }

    public static interface OnGroupExpandListener {
        public void onGroupExpand(int var1);
    }

    public static interface OnGroupCollapseListener {
        public void onGroupCollapse(int var1);
    }

    public static interface OnGroupClickListener {
        public boolean onGroupClick(ExpandableListView var1, View var2, int var3, long var4);
    }

    public static interface OnChildClickListener {
        public boolean onChildClick(ExpandableListView var1, View var2, int var3, int var4, long var5);
    }

    public static class ExpandableListContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public long id;
        public long packedPosition;
        public View targetView;

        public ExpandableListContextMenuInfo(View targetView, long packedPosition, long id2) {
            this.targetView = targetView;
            this.packedPosition = packedPosition;
            this.id = id2;
        }
    }
}

