/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.app._HoloActivity;
import android.support.v4.util.LongSparseArray;
import android.util.AttributeSet;
import android.util.SparseBooleanArray;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Checkable;
import android.widget.ListAdapter;
import com.actionbarsherlock.internal.view.menu.ContextMenuBuilder;
import com.actionbarsherlock.view.ActionMode;
import com.actionbarsherlock.view.Menu;
import com.actionbarsherlock.view.MenuItem;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.holoeverywhere.HoloEverywhere;
import org.holoeverywhere.R;
import org.holoeverywhere.app.Activity;
import org.holoeverywhere.drawable.DrawableCompat;
import org.holoeverywhere.widget.FastScroller;
import org.holoeverywhere.widget.HeaderViewListAdapter;
import org.holoeverywhere.widget.ListAdapterWrapper;

public class ListView
extends android.widget.ListView
implements _HoloActivity.OnWindowFocusChangeListener,
ContextMenuBuilder.ContextMenuInfoGetter {
    public static final int CHOICE_MODE_MULTIPLE = 2;
    @SuppressLint(value={"InlinedApi"})
    public static final int CHOICE_MODE_MULTIPLE_MODAL = 3;
    public static final int CHOICE_MODE_NONE = 0;
    public static final int CHOICE_MODE_SINGLE = 1;
    private static final boolean USE_ACTIVATED = Build.VERSION.SDK_INT >= 11;
    private Activity mActivity;
    private ListAdapterWrapper mAdapter;
    private boolean mAdapterHasStableIds;
    private LongSparseArray<Integer> mCheckedIdStates;
    private int mCheckedItemCount;
    private SparseBooleanArray mCheckStates;
    private ActionMode mChoiceActionMode;
    private int mChoiceMode;
    private ContextMenu.ContextMenuInfo mContextMenuInfo;
    private boolean mFastScrollEnabled;
    private FastScroller mFastScroller;
    private final List<HeaderViewListAdapter.ViewInfo> mFooterViewInfos = new ArrayList<HeaderViewListAdapter.ViewInfo>();
    private final List<HeaderViewListAdapter.ViewInfo> mHeaderViewInfos = new ArrayList<HeaderViewListAdapter.ViewInfo>();
    private boolean mForceFastScrollAlwaysVisibleDisable = false;
    private boolean mForceHeaderListAdapter = false;
    private boolean mIsAttached;
    private int mLastScrollState = 0;
    private final ListAdapterWrapper.ListAdapterCallback mListAdapterCallback = new ListAdapterWrapper.ListAdapterCallback(){

        @Override
        public void onChanged() {
            if (ListView.this.mFastScroller != null) {
                ListView.this.mFastScroller.onSectionsChanged();
            }
        }

        @Override
        public void onInvalidated() {
            if (ListView.this.mFastScroller != null) {
                ListView.this.mFastScroller.onSectionsChanged();
            }
        }

        @Override
        public View onPrepareView(View view, int position) {
            return ListView.this.onPrepareView(view, position);
        }
    };
    private MultiChoiceModeWrapper mMultiChoiceModeCallback;
    private final OnItemLongClickListenerWrapper mOnItemLongClickListenerWrapper;
    private AbsListView.OnScrollListener mOnScrollListener;
    private boolean mPaddingFromScroller = false;
    private int mVerticalScrollbarPosition = 0;

    public ListView(Context context) {
        this(context, null);
    }

    public ListView(Context context, AttributeSet attrs) {
        this(context, attrs, 16842868);
    }

    @SuppressLint(value={"NewApi"})
    public ListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (context instanceof Activity) {
            this.setActivity((Activity)context);
        }
        if (HoloEverywhere.DISABLE_OVERSCROLL_EFFECT && Build.VERSION.SDK_INT >= 9) {
            this.setOverScrollMode(2);
        }
        this.mOnItemLongClickListenerWrapper = new OnItemLongClickListenerWrapper();
        super.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this.mOnItemLongClickListenerWrapper);
        this.setLongClickable(false);
        if (Build.VERSION.SDK_INT >= 11) {
            super.setFastScrollAlwaysVisible(false);
        }
        super.setFastScrollEnabled(false);
        super.setChoiceMode(0);
        TypedArray a = context.obtainStyledAttributes(attrs, new int[]{16843302, 16843573, 16843051, 16843459, 16843458}, defStyle, R.style.Holo_ListView);
        this.setFastScrollEnabled(a.getBoolean(0, false));
        this.setFastScrollAlwaysVisible(a.getBoolean(1, false));
        this.setChoiceMode(a.getInt(2, 0));
        if (!a.hasValue(3) && Build.VERSION.SDK_INT >= 9) {
            super.setOverscrollFooter(null);
        }
        if (!a.hasValue(4) && Build.VERSION.SDK_INT >= 9) {
            super.setOverscrollHeader(null);
        }
        a.recycle();
    }

    public void addFooterView(View v) {
        this.addFooterView(v, null, true);
    }

    public void addFooterView(View v, Object data, boolean isSelectable) {
        if (this.mAdapter != null && !(this.mAdapter instanceof HeaderViewListAdapter)) {
            throw new IllegalStateException("Cannot add footer view to list -- setAdapter has already been called.");
        }
        HeaderViewListAdapter.ViewInfo info = new HeaderViewListAdapter.ViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mFooterViewInfos.add(info);
        if (this.mAdapter != null) {
            this.invalidateViews();
        }
    }

    public void addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    public void addHeaderView(View v, Object data, boolean isSelectable) {
        if (this.mAdapter != null && !(this.mAdapter instanceof HeaderViewListAdapter)) {
            throw new IllegalStateException("Cannot add header view to list -- setAdapter has already been called.");
        }
        HeaderViewListAdapter.ViewInfo info = new HeaderViewListAdapter.ViewInfo();
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
        if (this.mAdapter != null) {
            this.invalidateViews();
        }
    }

    public void clearChoices() {
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        this.mCheckedItemCount = 0;
    }

    protected ContextMenu.ContextMenuInfo createContextMenuInfo(View view, int position, long id2) {
        return new AdapterView.AdapterContextMenuInfo(view, position, id2);
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mFastScroller != null) {
            int scrollY = this.getScrollY();
            if (scrollY != 0) {
                int restoreCount = canvas.save();
                canvas.translate(0.0f, (float)scrollY);
                this.mFastScroller.draw(canvas);
                canvas.restoreToCount(restoreCount);
            } else {
                this.mFastScroller.draw(canvas);
            }
        }
    }

    void drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        Drawable divider = this.getDivider();
        divider.setBounds(bounds);
        divider.draw(canvas);
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public ListAdapter getAdapterSource() {
        return this.mAdapter == null ? null : this.mAdapter.getWrappedAdapter();
    }

    @SuppressLint(value={"NewApi"})
    public int getCheckedItemCount() {
        return this.mCheckedItemCount;
    }

    public long[] getCheckedItemIds() {
        if (this.mChoiceMode == 0 || this.mCheckedIdStates == null || this.mAdapter == null) {
            return new long[0];
        }
        LongSparseArray<Integer> idStates = this.mCheckedIdStates;
        int count = idStates.size();
        long[] ids = new long[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = idStates.keyAt(i);
        }
        return ids;
    }

    public int getCheckedItemPosition() {
        if (this.mChoiceMode == 1 && this.mCheckStates != null && this.mCheckStates.size() == 1) {
            return this.mCheckStates.keyAt(0);
        }
        return -1;
    }

    public SparseBooleanArray getCheckedItemPositions() {
        if (this.mChoiceMode != 0) {
            return this.mCheckStates;
        }
        return null;
    }

    @Deprecated
    public long[] getCheckItemIds() {
        return this.getCheckedItemIds();
    }

    public int getChoiceMode() {
        return this.mChoiceMode;
    }

    @Override
    public ContextMenu.ContextMenuInfo getContextMenuInfo() {
        return this.mContextMenuInfo;
    }

    public int getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    public int getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    public int getVerticalScrollbarPosition() {
        return this.mVerticalScrollbarPosition;
    }

    public int getVerticalScrollbarWidth() {
        this.mForceFastScrollAlwaysVisibleDisable = true;
        int superWidth = super.getVerticalScrollbarWidth();
        this.mForceFastScrollAlwaysVisibleDisable = false;
        if (this.isFastScrollAlwaysVisible()) {
            return Math.max(superWidth, this.mFastScroller.getWidth());
        }
        return superWidth;
    }

    void invokeOnItemScrollListener() {
        int mFirstPosition = this.getFirstVisiblePosition();
        int mItemCount = this.getCount();
        if (this.mFastScroller != null) {
            this.mFastScroller.onScroll((AbsListView)this, mFirstPosition, this.getChildCount(), mItemCount);
        }
        if (this.mOnScrollListener != null) {
            this.mOnScrollListener.onScroll((AbsListView)this, mFirstPosition, this.getChildCount(), mItemCount);
        }
        this.onScrollChanged(0, 0, 0, 0);
    }

    public boolean isAttached() {
        return this.mIsAttached;
    }

    public boolean isFastScrollAlwaysVisible() {
        if (this.mForceFastScrollAlwaysVisibleDisable) {
            return false;
        }
        return this.mFastScrollEnabled && this.mFastScroller.isAlwaysShowEnabled();
    }

    @ViewDebug.ExportedProperty
    public boolean isFastScrollEnabled() {
        return this.mFastScrollEnabled;
    }

    public boolean isForceHeaderListAdapter() {
        return this.mForceHeaderListAdapter;
    }

    @SuppressLint(value={"NewApi"})
    public boolean isInScrollingContainer() {
        for (ViewParent p = this.getParent(); p != null && p instanceof ViewGroup; p = p.getParent()) {
            if (Build.VERSION.SDK_INT < 14 || !((ViewGroup)p).shouldDelayChildPressedState()) continue;
            return true;
        }
        return false;
    }

    public boolean isItemChecked(int position) {
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            return this.mCheckStates.get(position);
        }
        return false;
    }

    public boolean isPaddingFromScroller() {
        return this.mPaddingFromScroller;
    }

    protected boolean isVerticalScrollBarHidden() {
        return this.mFastScroller != null && this.mFastScroller.isVisible();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttached = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttached = false;
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        if (gainFocus && this.getSelectedItemPosition() < 0 && !this.isInTouchMode() && !this.mIsAttached && this.mAdapter != null) {
            this.updateOnScreenCheckedViews();
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.mIsAttached) {
            return false;
        }
        if (this.mFastScroller != null && this.mFastScroller.onInterceptTouchEvent(ev)) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 23: 
            case 66: {
                if (!this.isEnabled()) {
                    return true;
                }
                if (!this.isClickable() || !this.isPressed() || this.getSelectedItemPosition() < 0 || this.mAdapter == null || this.getSelectedItemPosition() >= this.mAdapter.getCount()) break;
                View view = this.getChildAt(this.getSelectedItemPosition() - this.getFirstVisiblePosition());
                if (view != null) {
                    this.performItemClick(view, this.getSelectedItemPosition(), this.getSelectedItemId());
                    view.setPressed(false);
                }
                this.setPressed(false);
                return true;
            }
        }
        return super.onKeyUp(keyCode, event);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int mOldItemCount = this.getCount();
        super.onLayout(changed, l, t, r, b);
        int mItemCount = this.getCount();
        if (this.mFastScroller != null && mItemCount != mOldItemCount) {
            this.mFastScroller.onItemCountChanged(mOldItemCount, mItemCount);
        }
    }

    public View onPrepareView(View view, int position) {
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates != null) {
                this.setStateOnView(view, this.mCheckStates.get(position));
            } else {
                this.setStateOnView(view, false);
            }
        }
        return view;
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.checkState != null) {
            this.mCheckStates = ss.checkState;
        }
        if (ss.checkIdState != null) {
            this.mCheckedIdStates = ss.checkIdState;
        }
        this.mCheckedItemCount = ss.checkedItemCount;
        if (ss.inActionMode && this.mChoiceMode == 3 && this.mMultiChoiceModeCallback != null) {
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        ss.inActionMode = this.mChoiceMode == 3 && this.mChoiceActionMode != null;
        ss.checkState = this.mCheckStates;
        ss.checkIdState = this.mCheckedIdStates;
        ss.checkedItemCount = this.mCheckedItemCount;
        return ss;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mFastScroller != null) {
            this.mFastScroller.onSizeChanged(w, h, oldw, oldh);
        }
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.isEnabled()) {
            return this.isClickable() || this.isLongClickable();
        }
        if (!this.mIsAttached) {
            return false;
        }
        if (this.mFastScroller != null && this.mFastScroller.onTouchEvent(ev)) {
            return true;
        }
        return super.onTouchEvent(ev);
    }

    @Override
    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        if (hasWindowFocus) {
            this.updateOnScreenCheckedViews();
        }
    }

    public boolean performItemClick(View view, int position, long id2) {
        boolean handled = false;
        boolean dispatchItemClick = true;
        if (this.mChoiceMode != 0) {
            handled = true;
            boolean checkedStateChanged = false;
            if (this.mChoiceMode == 2 || this.mChoiceMode == 3 && this.mChoiceActionMode != null) {
                boolean newValue = !this.mCheckStates.get(position, false);
                this.mCheckStates.put(position, newValue);
                if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                    if (newValue) {
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                    } else {
                        this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                    }
                }
                this.mCheckedItemCount = newValue ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
                if (this.mChoiceActionMode != null) {
                    this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, newValue);
                    dispatchItemClick = false;
                }
                checkedStateChanged = true;
            } else if (this.mChoiceMode == 1) {
                boolean newValue;
                boolean bl = newValue = !this.mCheckStates.get(position, false);
                if (newValue) {
                    this.mCheckStates.clear();
                    this.mCheckStates.put(position, true);
                    if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                        this.mCheckedIdStates.clear();
                        this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                    }
                    this.mCheckedItemCount = 1;
                } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                    this.mCheckedItemCount = 0;
                }
                checkedStateChanged = true;
            }
            if (checkedStateChanged) {
                this.updateOnScreenCheckedViews();
            }
        }
        if (dispatchItemClick) {
            handled |= super.performItemClick(view, position, id2);
        }
        return handled;
    }

    public boolean performItemLongClick(View child, int longPressPosition, long longPressId) {
        if (this.mChoiceMode == 3) {
            if (this.mChoiceActionMode == null && (this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback)) != null) {
                this.setItemChecked(longPressPosition, true);
                this.performHapticFeedback(0);
            }
            return true;
        }
        boolean handled = false;
        if (this.mOnItemLongClickListenerWrapper.wrapped != null) {
            handled = this.mOnItemLongClickListenerWrapper.wrapped.onItemLongClick((AdapterView)this, child, longPressPosition, longPressId);
        }
        if (!handled) {
            this.mContextMenuInfo = this.createContextMenuInfo(child, longPressPosition, longPressId);
            handled = super.showContextMenuForChild((View)this);
        }
        if (handled) {
            this.performHapticFeedback(0);
        }
        return handled;
    }

    protected void recomputePaddingFromScroller() {
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int right = this.getPaddingRight();
        int bottom = this.getPaddingBottom();
        if (this.mPaddingFromScroller) {
            int scrollbarWidth = this.getVerticalScrollbarWidth();
            switch (this.mVerticalScrollbarPosition) {
                case 1: {
                    this.setPadding(scrollbarWidth, top, right, bottom);
                    break;
                }
                default: {
                    this.setPadding(left, top, scrollbarWidth, bottom);
                    break;
                }
            }
        } else {
            this.setPadding(0, top, 0, bottom);
        }
    }

    public boolean removeFooterView(View v) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeFooter(v)) {
                this.invalidateViews();
                result = true;
            }
            this.removeViewInfo(v, this.mFooterViewInfos);
            return result;
        }
        return false;
    }

    public boolean removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeHeader(v)) {
                this.invalidateViews();
                result = true;
            }
            this.removeViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    private void removeViewInfo(View v, List<HeaderViewListAdapter.ViewInfo> where) {
        int len = where.size();
        for (int i = 0; i < len; ++i) {
            HeaderViewListAdapter.ViewInfo info = where.get(i);
            if (info.view != v) continue;
            where.remove(i);
            break;
        }
    }

    protected void reportScrollStateChange(int newState) {
        if (newState != this.mLastScrollState && this.mOnScrollListener != null) {
            this.mLastScrollState = newState;
            this.mOnScrollListener.onScrollStateChanged((AbsListView)this, newState);
        }
    }

    public final void setActivity(Activity activity) {
        this.mActivity = activity;
        if (this.mActivity != null) {
            this.mActivity.addOnWindowFocusChangeListener(this);
        }
    }

    public void setAdapter(ListAdapter adapter) {
        this.mAdapter = adapter == null ? null : (this.mForceHeaderListAdapter || this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0 ? new HeaderViewListAdapter(this.mHeaderViewInfos, this.mFooterViewInfos, adapter, this.mListAdapterCallback) : new ListAdapterWrapper(adapter, this.mListAdapterCallback));
        if (this.mAdapter != null) {
            this.mAdapterHasStableIds = this.mAdapter.hasStableIds();
            if (this.mChoiceMode != 0 && this.mAdapterHasStableIds && this.mCheckedIdStates == null) {
                this.mCheckedIdStates = new LongSparseArray();
            }
        }
        if (this.mCheckStates != null) {
            this.mCheckStates.clear();
        }
        if (this.mCheckedIdStates != null) {
            this.mCheckedIdStates.clear();
        }
        super.setAdapter((ListAdapter)this.mAdapter);
    }

    public void setChoiceMode(int choiceMode) {
        this.mChoiceMode = choiceMode;
        if (this.mChoiceActionMode != null) {
            this.mChoiceActionMode.finish();
            this.mChoiceActionMode = null;
        }
        if (this.mChoiceMode != 0) {
            if (this.mCheckStates == null) {
                this.mCheckStates = new SparseBooleanArray();
            }
            if (this.mCheckedIdStates == null && this.mAdapter != null && this.mAdapter.hasStableIds()) {
                this.mCheckedIdStates = new LongSparseArray();
            }
            if (this.mChoiceMode == 3) {
                this.clearChoices();
                this.setLongClickable(true);
            }
        }
    }

    public void setFastScrollAlwaysVisible(boolean alwaysShow) {
        if (alwaysShow && !this.mFastScrollEnabled) {
            this.setFastScrollEnabled(true);
        }
        if (this.mFastScroller != null) {
            this.mFastScroller.setAlwaysShow(alwaysShow);
        }
        try {
            Method method = View.class.getDeclaredMethod("computeOpaqueFlags", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this, new Object[0]);
            method = View.class.getDeclaredMethod("recomputePadding", new Class[0]);
            method.setAccessible(true);
            method.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (alwaysShow) {
            this.setPaddingFromScroller(true);
        }
    }

    public void setFastScrollEnabled(boolean enabled) {
        this.mFastScrollEnabled = enabled;
        if (enabled) {
            if (this.mFastScroller == null) {
                this.mFastScroller = new FastScroller(this.getContext(), this);
            }
        } else if (this.mFastScroller != null) {
            this.mFastScroller.stop();
            this.mFastScroller = null;
        }
    }

    public void setForceHeaderListAdapter(boolean forceHeaderListAdapter) {
        this.mForceHeaderListAdapter = forceHeaderListAdapter;
    }

    public void setItemChecked(int position, boolean value) {
        if (this.mChoiceMode == 0) {
            return;
        }
        if (value && this.mChoiceMode == 3 && this.mChoiceActionMode == null) {
            this.mChoiceActionMode = this.startActionMode(this.mMultiChoiceModeCallback);
        }
        if (this.mChoiceMode == 2 || this.mChoiceMode == 3) {
            boolean oldValue = this.mCheckStates.get(position);
            this.mCheckStates.put(position, value);
            if (this.mCheckedIdStates != null && this.mAdapter.hasStableIds()) {
                if (value) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                } else {
                    this.mCheckedIdStates.delete(this.mAdapter.getItemId(position));
                }
            }
            if (oldValue != value) {
                this.mCheckedItemCount = value ? ++this.mCheckedItemCount : --this.mCheckedItemCount;
            }
            if (this.mChoiceActionMode != null) {
                long id2 = this.mAdapter.getItemId(position);
                this.mMultiChoiceModeCallback.onItemCheckedStateChanged(this.mChoiceActionMode, position, id2, value);
            }
        } else {
            boolean updateIds;
            boolean bl = updateIds = this.mCheckedIdStates != null && this.mAdapter.hasStableIds();
            if (value || this.isItemChecked(position)) {
                this.mCheckStates.clear();
                if (updateIds) {
                    this.mCheckedIdStates.clear();
                }
            }
            if (value) {
                this.mCheckStates.put(position, true);
                if (updateIds) {
                    this.mCheckedIdStates.put(this.mAdapter.getItemId(position), (Object)position);
                }
                this.mCheckedItemCount = 1;
            } else if (this.mCheckStates.size() == 0 || !this.mCheckStates.valueAt(0)) {
                this.mCheckedItemCount = 0;
            }
        }
        this.updateOnScreenCheckedViews();
    }

    public void setMultiChoiceModeListener(MultiChoiceModeListener listener) {
        if (this.mMultiChoiceModeCallback == null) {
            this.mMultiChoiceModeCallback = new MultiChoiceModeWrapper();
        }
        this.mMultiChoiceModeCallback.setWrapped(listener);
    }

    public void setOnItemLongClickListener(AdapterView.OnItemLongClickListener listener) {
        this.mOnItemLongClickListenerWrapper.setWrapped(listener);
    }

    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOnScrollListener = l;
        super.setOnScrollListener(this.mOnScrollListener);
    }

    public void setPaddingFromScroller(boolean paddingFromScroller) {
        this.mPaddingFromScroller = paddingFromScroller;
        this.recomputePaddingFromScroller();
    }

    public void setSelectionAfterHeaderView() {
        this.setSelection(this.mHeaderViewInfos.size());
    }

    public void setSelector(int resID) {
        this.setSelector(DrawableCompat.getDrawable(this.getResources(), resID));
    }

    @SuppressLint(value={"NewApi"})
    protected final void setStateOnView(View child, boolean value) {
        if (child instanceof Checkable) {
            ((Checkable)child).setChecked(value);
        } else if (USE_ACTIVATED) {
            child.setActivated(value);
        }
    }

    public void setVerticalScrollbarPosition(int position) {
        this.mVerticalScrollbarPosition = position;
        if (this.mFastScroller != null) {
            this.mFastScroller.setScrollbarPosition(position);
        }
        this.recomputePaddingFromScroller();
    }

    public boolean showContextMenuForChild(View originalView) {
        int longPressPosition = this.getPositionForView(originalView);
        if (longPressPosition >= 0) {
            long longPressId = this.mAdapter.getItemId(longPressPosition);
            boolean handled = false;
            if (this.mOnItemLongClickListenerWrapper.wrapped != null) {
                handled = this.mOnItemLongClickListenerWrapper.wrapped.onItemLongClick((AdapterView)this, originalView, longPressPosition, longPressId);
            }
            if (!handled) {
                this.mContextMenuInfo = this.createContextMenuInfo(this.getChildAt(longPressPosition - this.getFirstVisiblePosition()), longPressPosition, longPressId);
                handled = super.showContextMenuForChild(originalView);
            }
            return handled;
        }
        return false;
    }

    public ActionMode startActionMode(ActionMode.Callback callback) {
        if (this.mActivity != null) {
            return this.mActivity.startActionMode(callback);
        }
        throw new RuntimeException("HoloEverywhere.ListView (" + this + ") don't have reference on Activity");
    }

    private void updateOnScreenCheckedViews() {
        if (this.mCheckStates == null) {
            return;
        }
        int firstPos = this.getFirstVisiblePosition();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            int position = firstPos + i;
            boolean value = this.mCheckStates.get(position);
            this.setStateOnView(child, value);
        }
    }

    static final class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        int checkedItemCount;
        LongSparseArray<Integer> checkIdState;
        SparseBooleanArray checkState;
        boolean inActionMode;

        public SavedState(Parcel in) {
            super(in);
            this.inActionMode = in.readByte() != 0;
            this.checkedItemCount = in.readInt();
            this.checkState = in.readSparseBooleanArray();
            int N = in.readInt();
            if (N > 0) {
                this.checkIdState = new LongSparseArray();
                for (int i = 0; i < N; ++i) {
                    long key = in.readLong();
                    int value = in.readInt();
                    this.checkIdState.put(key, (Object)value);
                }
            }
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByte((byte)(this.inActionMode ? 1 : 0));
            out.writeInt(this.checkedItemCount);
            out.writeSparseBooleanArray(this.checkState);
            int N = this.checkIdState != null ? this.checkIdState.size() : 0;
            out.writeInt(N);
            for (int i = 0; i < N; ++i) {
                out.writeLong(this.checkIdState.keyAt(i));
                out.writeInt(((Integer)this.checkIdState.valueAt(i)).intValue());
            }
        }
    }

    private final class OnItemLongClickListenerWrapper
    implements AdapterView.OnItemLongClickListener {
        private AdapterView.OnItemLongClickListener wrapped;

        private OnItemLongClickListenerWrapper() {
        }

        public boolean onItemLongClick(AdapterView<?> adapterView, View view, int position, long id2) {
            return ListView.this.performItemLongClick(view, position, id2);
        }

        public void setWrapped(AdapterView.OnItemLongClickListener wrapped) {
            this.wrapped = wrapped;
            if (wrapped != null) {
                ListView.this.setLongClickable(true);
            }
        }
    }

    private final class MultiChoiceModeWrapper
    implements MultiChoiceModeListener {
        private MultiChoiceModeListener mWrapped;

        private MultiChoiceModeWrapper() {
        }

        @Override
        public boolean onActionItemClicked(ActionMode mode, MenuItem item) {
            return this.mWrapped.onActionItemClicked(mode, item);
        }

        @Override
        public boolean onCreateActionMode(ActionMode mode, Menu menu) {
            if (this.mWrapped.onCreateActionMode(mode, menu)) {
                ListView.this.setLongClickable(false);
                return true;
            }
            return false;
        }

        @Override
        public void onDestroyActionMode(ActionMode mode) {
            this.mWrapped.onDestroyActionMode(mode);
            ListView.this.mChoiceActionMode = null;
            ListView.this.clearChoices();
            ListView.this.updateOnScreenCheckedViews();
            ListView.this.setLongClickable(true);
        }

        @Override
        @SuppressLint(value={"NewApi"})
        public void onItemCheckedStateChanged(ActionMode mode, int position, long id2, boolean checked) {
            this.mWrapped.onItemCheckedStateChanged(mode, position, id2, checked);
            if (ListView.this.getCheckedItemCount() == 0) {
                mode.finish();
            }
        }

        @Override
        public boolean onPrepareActionMode(ActionMode mode, Menu menu) {
            return this.mWrapped.onPrepareActionMode(mode, menu);
        }

        public void setWrapped(MultiChoiceModeListener wrapped) {
            this.mWrapped = wrapped;
        }
    }

    public static interface MultiChoiceModeListener
    extends ActionMode.Callback {
        public void onItemCheckedStateChanged(ActionMode var1, int var2, long var3, boolean var5);
    }
}

