package org.holoeverywhere.plugin.extension

import org.gradle.api.Project
import org.gradle.util.Configurable
import org.gradle.util.ConfigureUtil
import org.holoeverywhere.plugin.extension.signing.SignConfiguration

class SigningContainer implements Configurable<SigningContainer> {
    SigningContainer(Project project) {
        this.project = project

        this.release = new SignConfiguration(project)
        this.debug = new SignConfiguration(project)
    }

    private final Project project
    def final SignConfiguration release
    def final SignConfiguration debug
    def boolean enable = true
    def boolean required = false

    def SignConfiguration release(Closure<?> closure) {
        return release.configure(closure)
    }

    def SignConfiguration debug(Closure<?> closure) {
        return debug.configure(closure)
    }

    def void all(Closure<?> closure) {
        debug.configure(closure)
        release.configure(closure)
    }

    def void key(String key) {
        all { SignConfiguration configuration -> configuration.key(key) }
    }

    @Override
    SigningContainer configure(Closure closure) {
        ConfigureUtil.configure(closure, this, false)
    }
}

