/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.plugin.internal;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.StaticLockingMavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.util.CollectionUtils;
import org.holoeverywhere.plugin.internal.HoloEverywhereMavenPublisher;

public class HoloEverywherePublishToMavenRepository
extends PublishToMavenRepository {
    public static final String SIGN_CLASSIFIER = "sign";
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    public MavenArtifact mainArtifact;
    public MavenPublisher publisher;

    @Inject
    public HoloEverywherePublishToMavenRepository(Factory<LoggingManagerInternal> loggingManagerFactory) {
        super(loggingManagerFactory);
        this.loggingManagerFactory = loggingManagerFactory;
        this.publisher = new HoloEverywhereMavenPublisher(this);
    }

    public Factory<LoggingManagerInternal> getLoggingManagerFactory() {
        return this.loggingManagerFactory;
    }

    protected void doPublish(final MavenPublicationInternal publication, final MavenArtifactRepository repository) {
        new PublishOperation((Publication)publication, (ArtifactRepository)repository){

            protected void publish() throws Exception {
                StaticLockingMavenPublisher staticLockingPublisher = new StaticLockingMavenPublisher(HoloEverywherePublishToMavenRepository.this.publisher);
                ValidatingMavenPublisher validatingPublisher = new ValidatingMavenPublisher((MavenPublisher)staticLockingPublisher);
                validatingPublisher.publish(HoloEverywherePublishToMavenRepository.this.normalize(publication.asNormalisedPublication()), repository);
            }
        }.run();
    }

    private MavenNormalizedPublication normalize(MavenNormalizedPublication publication) {
        Set artifacts = publication.getArtifacts();
        artifacts.removeAll(CollectionUtils.filter((Set)artifacts, (Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact element) {
                return HoloEverywherePublishToMavenRepository.SIGN_CLASSIFIER.equals(element.getClassifier()) && !element.getFile().exists();
            }
        }));
        for (MavenArtifact artifact : artifacts) {
            if (!SIGN_CLASSIFIER.equals(artifact.getClassifier())) continue;
            artifact.setClassifier(null);
        }
        return publication;
    }
}

