/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.plugin.internal;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.ant.AttachedArtifact;
import org.apache.maven.artifact.ant.Authentication;
import org.apache.maven.artifact.ant.DeployTask;
import org.apache.maven.artifact.ant.InstallDeployTaskSupport;
import org.apache.maven.artifact.ant.Pom;
import org.apache.maven.artifact.ant.RemoteRepository;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.file.TmpDirTemporaryFileProvider;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.publication.maven.internal.ant.CustomInstallDeployTaskSupport;
import org.gradle.api.publication.maven.internal.ant.MavenSettingsSupplier;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.internal.Factory;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.util.AntUtil;
import org.gradle.util.GUtil;
import org.holoeverywhere.plugin.internal.HoloEverywherePublishToMavenRepository;
import org.holoeverywhere.plugin.internal.MainArtifactHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoloEverywhereMavenPublisher
implements MavenPublisher {
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private static Logger logger = LoggerFactory.getLogger(HoloEverywhereMavenPublisher.class);
    protected final Factory<File> temporaryDirFactory;
    private final HoloEverywherePublishToMavenRepository task;

    public HoloEverywhereMavenPublisher(HoloEverywherePublishToMavenRepository task) {
        this.loggingManagerFactory = task.getLoggingManagerFactory();
        this.temporaryDirFactory = task.getTemporaryDirFactory();
        this.task = task;
    }

    public void publish(MavenNormalizedPublication publication, MavenArtifactRepository artifactRepository) {
        logger.info("Publishing to repository {}", (Object)artifactRepository);
        HoloEverywhereDeployTask deployTask = new HoloEverywhereDeployTask(this.temporaryDirFactory);
        deployTask.setUniqueVersion(true);
        deployTask.setProject(AntUtil.createProject());
        EmptyMavenSettingsSupplier mavenSettingsSupplier = new EmptyMavenSettingsSupplier();
        mavenSettingsSupplier.supply((InstallDeployTaskSupport)deployTask);
        this.postConfigure(deployTask, artifactRepository);
        this.addPomAndArtifacts((InstallDeployTaskSupport)deployTask, publication, this.task.mainArtifact);
        this.execute((InstallDeployTaskSupport)deployTask);
        mavenSettingsSupplier.done();
    }

    protected void postConfigure(HoloEverywhereDeployTask task, MavenArtifactRepository artifactRepository) {
        this.addRepository(task, artifactRepository);
    }

    private void addRepository(HoloEverywhereDeployTask deployTask, MavenArtifactRepository artifactRepository) {
        RemoteRepository mavenRepository = new MavenRemoteRepositoryFactory(artifactRepository).create();
        deployTask.addRemoteRepository(mavenRepository);
    }

    private void addPomAndArtifacts(InstallDeployTaskSupport installOrDeployTask, MavenNormalizedPublication publication, MavenArtifact mainArtifact) {
        Pom pom = new Pom();
        pom.setProject(installOrDeployTask.getProject());
        pom.setFile(publication.getPomFile());
        installOrDeployTask.addPom(pom);
        if (mainArtifact == null) {
            mainArtifact = MainArtifactHelper.determineMainArtifact(publication.getName(), null, publication.getArtifacts());
        }
        installOrDeployTask.setFile(mainArtifact == null ? publication.getPomFile() : mainArtifact.getFile());
        for (MavenArtifact mavenArtifact : publication.getArtifacts()) {
            if (mavenArtifact == mainArtifact) continue;
            AttachedArtifact attachedArtifact = installOrDeployTask.createAttach();
            attachedArtifact.setClassifier((String)GUtil.elvis((Object)mavenArtifact.getClassifier(), (Object)""));
            attachedArtifact.setType((String)GUtil.elvis((Object)mavenArtifact.getExtension(), (Object)""));
            attachedArtifact.setFile(mavenArtifact.getFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(InstallDeployTaskSupport deployTask) {
        LoggingManagerInternal loggingManager = (LoggingManagerInternal)this.loggingManagerFactory.create();
        loggingManager.captureStandardOutput(LogLevel.INFO).start();
        try {
            deployTask.execute();
        }
        finally {
            loggingManager.stop();
        }
    }

    public class EmptyMavenSettingsSupplier
    implements MavenSettingsSupplier {
        private final TemporaryFileProvider temporaryFileProvider = new TmpDirTemporaryFileProvider();
        private File settingsXml;

        public void supply(InstallDeployTaskSupport installDeployTaskSupport) {
            try {
                this.settingsXml = this.temporaryFileProvider.createTemporaryFile("gradle_empty_settings", ".xml", new String[0]);
                FileUtils.writeStringToFile((File)this.settingsXml, (String)"<settings/>");
                this.settingsXml.deleteOnExit();
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
            installDeployTaskSupport.setSettingsFile(this.settingsXml);
        }

        public void done() {
            if (this.settingsXml != null) {
                this.settingsXml.delete();
            }
        }
    }

    class MavenRemoteRepositoryFactory
    implements Factory<RemoteRepository> {
        private final MavenArtifactRepository artifactRepository;

        public MavenRemoteRepositoryFactory(MavenArtifactRepository artifactRepository) {
            this.artifactRepository = artifactRepository;
        }

        public RemoteRepository create() {
            RemoteRepository remoteRepository = new RemoteRepository();
            remoteRepository.setUrl(this.artifactRepository.getUrl().toString());
            PasswordCredentials credentials = this.artifactRepository.getCredentials();
            String username = credentials.getUsername();
            String password = credentials.getPassword();
            if (username != null || password != null) {
                Authentication authentication = new Authentication();
                authentication.setUserName(username);
                authentication.setPassword(password);
                remoteRepository.addAuthentication(authentication);
            }
            return remoteRepository;
        }
    }

    private static class HoloEverywhereDeployTask
    extends DeployTask
    implements CustomInstallDeployTaskSupport {
        private final Factory<File> tmpDirFactory;

        public synchronized Settings getSettings() {
            return super.getSettings();
        }

        public synchronized PlexusContainer getContainer() {
            return super.getContainer();
        }

        public void doExecute() {
            super.doExecute();
        }

        public void clearAttachedArtifactsList() {
            this.attachedArtifacts.clear();
        }

        public HoloEverywhereDeployTask(Factory<File> tmpDirFactory) {
            this.tmpDirFactory = tmpDirFactory;
        }

        protected ArtifactRepository createLocalArtifactRepository() {
            ArtifactRepositoryLayout repositoryLayout = (ArtifactRepositoryLayout)this.lookup(ArtifactRepositoryLayout.ROLE, this.getLocalRepository().getLayout());
            return new DefaultArtifactRepository("local", ((File)this.tmpDirFactory.create()).toURI().toString(), repositoryLayout);
        }

        protected void updateRepositoryWithSettings(RemoteRepository repository) {
        }
    }
}

