/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.plugin.internal;

import java.util.Set;
import org.gradle.api.publish.maven.InvalidMavenPublicationException;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.specs.Spec;
import org.gradle.util.CollectionUtils;

public class MainArtifactHelper {
    public static MavenArtifact determineMainArtifact(String publicationName, final String possibleExtension, Set<MavenArtifact> mavenArtifacts) {
        MavenArtifact artifact;
        Set candidateMainArtifacts = CollectionUtils.filter(mavenArtifacts, (Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact element) {
                return element.getClassifier() == null || element.getClassifier().length() == 0;
            }
        });
        if (possibleExtension != null && possibleExtension.length() > 0 && (artifact = (MavenArtifact)CollectionUtils.findFirst((Iterable)candidateMainArtifacts, (Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact element) {
                return possibleExtension.equals(element.getExtension());
            }
        })) != null) {
            return artifact;
        }
        if (candidateMainArtifacts.isEmpty()) {
            return null;
        }
        if (candidateMainArtifacts.size() > 1) {
            throw new InvalidMavenPublicationException(publicationName, "Cannot determine main artifact - multiple artifacts found with empty classifier.");
        }
        return (MavenArtifact)candidateMainArtifacts.iterator().next();
    }
}

