/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.plugin.internal;

import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.internal.PublishOperation;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MavenNormalizedPublication;
import org.gradle.api.publish.maven.internal.publisher.MavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.StaticLockingMavenPublisher;
import org.gradle.api.publish.maven.internal.publisher.ValidatingMavenPublisher;
import org.gradle.api.publish.maven.tasks.PublishToMavenRepository;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Factory;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.util.CollectionUtils;
import org.holoeverywhere.plugin.internal.HoloEverywhereMavenPublisher;

public class HoloEverywherePublishToMavenRepository
extends PublishToMavenRepository {
    public static final String SIGN_CLASSIFIER = "sign";
    public static final String POST_SIGN_CLASSIFIER = ".sign";
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    public MavenArtifact mainArtifact;
    public MavenPublisher publisher;

    @Inject
    public HoloEverywherePublishToMavenRepository(Factory<LoggingManagerInternal> loggingManagerFactory) {
        super(loggingManagerFactory);
        this.loggingManagerFactory = loggingManagerFactory;
        this.publisher = new HoloEverywhereMavenPublisher(this);
    }

    public Factory<LoggingManagerInternal> getLoggingManagerFactory() {
        return this.loggingManagerFactory;
    }

    protected void doPublish(final MavenPublicationInternal publication, final MavenArtifactRepository repository) {
        new PublishOperation((Publication)publication, (ArtifactRepository)repository){

            protected void publish() throws Exception {
                StaticLockingMavenPublisher staticLockingPublisher = new StaticLockingMavenPublisher(HoloEverywherePublishToMavenRepository.this.publisher);
                ValidatingMavenPublisher validatingPublisher = new ValidatingMavenPublisher((MavenPublisher)staticLockingPublisher);
                validatingPublisher.publish(HoloEverywherePublishToMavenRepository.this.normalize(publication.asNormalisedPublication()), repository);
            }
        }.run();
    }

    private MavenNormalizedPublication normalize(MavenNormalizedPublication publication) {
        Set artifacts = publication.getArtifacts();
        artifacts.removeAll(CollectionUtils.filter((Set)artifacts, (Spec)new Spec<MavenArtifact>(){

            public boolean isSatisfiedBy(MavenArtifact element) {
                String classifier = element.getClassifier();
                return classifier != null && (classifier.equals(HoloEverywherePublishToMavenRepository.SIGN_CLASSIFIER) || classifier.endsWith(HoloEverywherePublishToMavenRepository.POST_SIGN_CLASSIFIER)) && !element.getFile().exists();
            }
        }));
        for (MavenArtifact artifact : artifacts) {
            String classifier = artifact.getClassifier();
            if (classifier == null) continue;
            if (classifier.equals(SIGN_CLASSIFIER)) {
                artifact.setClassifier(null);
            }
            if (!classifier.endsWith(POST_SIGN_CLASSIFIER)) continue;
            artifact.setClassifier(classifier.substring(0, classifier.length() - POST_SIGN_CLASSIFIER.length()));
        }
        return publication;
    }
}

