/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.translator;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class Grabber {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
    private final Map<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
    private final Map<String, File> fileMap = new HashMap<String, File>();
    private final File resFolder;
    public final Map<File, Map<String, String>> translateCache = new HashMap<File, Map<String, String>>();

    public static Grabber grabber(File resFolder) {
        return new Grabber(resFolder);
    }

    private Grabber(File resFolder) {
        this.resFolder = resFolder;
        this.fillFileMap();
    }

    protected void fillFileMap() {
        for (File file : this.resFolder.listFiles()) {
            if (!file.isDirectory()) continue;
            String locale = null;
            String dirName = file.getName();
            if (dirName.contentEquals("values")) {
                locale = "en";
            } else if (dirName.startsWith("values-")) {
                locale = dirName.substring(7).replace("-r", "_");
                if (locale.length() == 5) {
                    if (locale.charAt(2) != '_') {
                        locale = null;
                    }
                } else if (locale.length() != 2) {
                    locale = null;
                }
            }
            file = new File(file, "strings.xml");
            if (locale == null || !file.exists()) continue;
            this.fileMap.put(locale, file);
        }
    }

    public Map<String, Map<String, String>> getData() {
        return this.data;
    }

    public void grab(String name) {
        if (name == null || name.length() == 0) {
            return;
        }
        for (Map.Entry<String, File> entry : this.fileMap.entrySet()) {
            String locale = entry.getKey();
            String translate = this.grab(name, entry.getValue());
            if (translate == null) continue;
            Map<String, String> map = this.data.get(name);
            if (map == null) {
                map = new HashMap<String, String>();
                this.data.put(name, map);
            }
            map.put(locale, translate);
        }
    }

    public void grab(String ... names) {
        for (String name : names) {
            this.grab(name);
        }
    }

    protected String grab(String name, File file) {
        Map<String, String> cache = this.translateCache.get(file);
        if (cache == null) {
            cache = this.parse(file);
            this.translateCache.put(file, cache);
        }
        return cache.get(name);
    }

    private Map<String, String> parse(File file) {
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            XMLStreamReader reader = xmlInputFactory.createXMLStreamReader(new FileInputStream(file), "utf-8");
            String name = null;
            StringBuilder builder = null;
            int depth = 0;
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (builder != null) {
                            ++depth;
                        }
                        if (!"string".equals(reader.getLocalName())) break;
                        name = reader.getAttributeValue(null, "name");
                        if (name == null || name.length() == 0) {
                            name = null;
                            break;
                        }
                        builder = new StringBuilder();
                        depth = 0;
                        break;
                    }
                    case 4: {
                        if (builder == null) break;
                        builder.append(reader.getText());
                        break;
                    }
                    case 2: {
                        if (builder == null || depth-- != 0) break;
                        map.put(name, builder.toString());
                        name = null;
                        builder = null;
                    }
                }
            }
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void reset() {
        this.data.clear();
        this.translateCache.clear();
    }
}

