/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.translator;

import java.io.File;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.holoeverywhere.translator.Document;
import org.holoeverywhere.translator.Grabber;
import org.holoeverywhere.translator.Parser;
import org.holoeverywhere.translator.Processer;

public class Translator
extends AbstractMojo {
    private File sdk;
    private String[] input;
    private File outputDir;
    private File includeDir;
    private int version;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.input.length == 0) {
            this.getLog().info((CharSequence)"Not need to generate resources");
            return;
        }
        if (!Translator.validDir(this.sdk)) {
            this.getLog().error((CharSequence)("Android SDK path not valid: " + (this.sdk == null ? "null" : this.sdk.getAbsolutePath())));
            return;
        }
        File platform = new File(this.sdk, "platforms/android-" + this.version);
        if (!Translator.validDir(platform)) {
            this.getLog().error((CharSequence)("Platform path for version " + this.version + " not found: " + platform.getAbsolutePath()));
            return;
        }
        Grabber grabber = Grabber.grabber(new File(platform, "data/res"));
        this.getLog().info((CharSequence)("Res folder for compile: " + this.outputDir.getAbsolutePath()));
        this.getLog().info((CharSequence)"");
        for (String fileName : this.input) {
            File file = new File(this.includeDir, fileName);
            if (!Translator.validFile(file)) {
                this.getLog().error((CharSequence)("Input file not found: " + file.getAbsolutePath()));
                return;
            }
            Document document = Parser.parse(file);
            this.getLog().info((CharSequence)("Compile " + file.getName()));
            Processer.process(document, grabber, this.outputDir);
            this.getLog().info((CharSequence)"");
        }
    }

    private static boolean validDir(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    private static boolean validFile(File file) {
        return file != null && file.exists() && file.isFile();
    }
}

