/*
 * Decompiled with CFR 0.152.
 */
package org.holoeverywhere.translator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.holoeverywhere.translator.Grabber;
import org.json.JSONArray;
import org.json.JSONObject;

public class Document {
    protected final Map<String, Map<String, String>> data = new HashMap<String, Map<String, String>>();
    protected final List<String> grab = new ArrayList<String>();
    protected String prefix;
    protected String filenamePattern;
    protected boolean ignoreDefaultLocale;

    public synchronized Map<String, Map<String, String>> mergeData(Grabber grabber) {
        grabber.reset();
        grabber.grab(this.grab.toArray(new String[this.grab.size()]));
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>(grabber.getData());
        grabber.reset();
        for (Map.Entry<String, Map<String, String>> entry : this.data.entrySet()) {
            Map submap = (Map)map.get(entry.getKey());
            if (submap == null) {
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            submap.putAll(entry.getValue());
        }
        return map;
    }

    public Document parse(JSONObject object) {
        this.grab.clear();
        this.data.clear();
        this.prefix = object.optString("prefix", null);
        this.filenamePattern = object.optString("filename_pattern", "%s.xml");
        this.ignoreDefaultLocale = object.optBoolean("ignore_default_locale", false);
        if (object.has("grab")) {
            JSONArray grab = object.optJSONArray("grab");
            for (int i = 0; i < grab.length(); ++i) {
                String forGrab = grab.optString(i);
                if (forGrab == null) continue;
                this.grab.add(forGrab);
            }
        }
        if (object.has("data")) {
            JSONObject data = object.optJSONObject("data");
            Iterator keys = data.sortedKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key == null || key.length() == 0) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                this.data.put(key, map);
                JSONObject translates = data.optJSONObject(key);
                Iterator locales = translates.sortedKeys();
                while (locales.hasNext()) {
                    String locale = (String)locales.next();
                    if (locale == null || locale.length() == 0) continue;
                    map.put(locale, translates.optString(locale));
                }
            }
        }
        return this;
    }

    public String getNameForEntry(String key) {
        if (this.prefix == null) {
            return key;
        }
        return this.prefix + key;
    }
}

