/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.bom;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.bom.QueryCentral;
import org.honton.chas.bom.Sha1;

@Mojo(name="extract", requiresProject=false)
public class CreateBomMojo
extends AbstractMojo {
    @Parameter(property="bom.groupId", defaultValue="extracted")
    private String groupId;
    @Parameter(property="bom.artifactId", defaultValue="bom")
    private String artifactId;
    @Parameter(property="bom.version", defaultValue="1.0.0-SNAPSHOT")
    private String version;
    @Parameter(property="bom.source")
    private String source;
    @Parameter(property="bom.bom", defaultValue="pom.xml")
    private String output;
    private Sha1 sha1;
    private QueryCentral queryCentral = new QueryCentral();
    private SortedMap<String, Dependency> dependencies = new TreeMap<String, Dependency>();

    public void execute() throws MojoExecutionException {
        try {
            this.sha1 = new Sha1();
            if (this.source == null) {
                this.source = "";
            }
            if (this.source.endsWith(".tar.gz") || this.source.endsWith(".tar")) {
                this.extractTar();
            } else {
                this.findJars();
            }
            this.writeBom();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void findJars() throws IOException {
        try (Stream<Path> walk = Files.walk(Paths.get(this.source, new String[0]), new FileVisitOption[0]);){
            walk.filter(f -> f.getFileName().toString().endsWith(".jar")).forEach(this::extractJar);
        }
    }

    private void extractJar(Path jarPath) {
        if (!this.mavenBuilt(jarPath)) {
            this.findGAVfromSha1(jarPath);
        }
    }

    private boolean mavenBuilt(Path jarPath) {
        boolean bl;
        JarFile jarFile = new JarFile(jarPath.toFile());
        try {
            bl = this.findPomProperties(jarFile);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Error during extraction of " + jarPath + " : " + e.getMessage()), (Throwable)e);
                return false;
            }
        }
        jarFile.close();
        return bl;
    }

    private boolean findPomProperties(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith("META-INF/maven/") || !name.endsWith("/pom.properties")) continue;
            this.dependencyFromProperties(jarFile, entry);
            return true;
        }
        return false;
    }

    private void dependencyFromProperties(JarFile jarFile, JarEntry entry) throws IOException {
        Properties properties = new Properties();
        properties.load(jarFile.getInputStream(entry));
        Dependency dependency = new Dependency();
        dependency.setGroupId(properties.getProperty("groupId"));
        dependency.setArtifactId(properties.getProperty("artifactId"));
        dependency.setVersion(properties.getProperty("version"));
        dependency.setClassifier(properties.getProperty("classifier"));
        this.addDependency(dependency);
    }

    private void findGAVfromSha1(Path jarPath) {
        try {
            Dependency dependency = this.queryCentral.getDependency(this.sha1.getChecksum(jarPath));
            if (dependency != null) {
                this.addDependency(dependency);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error while querying checksum of " + jarPath + " : " + e.getMessage()), (Throwable)e);
        }
    }

    private void addDependency(Dependency dependency) {
        this.dependencies.put(dependency.getManagementKey() + ":" + dependency.getVersion(), dependency);
    }

    private ArchiveInputStream getArchiveInputStream() throws IOException {
        BufferedInputStream bi = new BufferedInputStream(Files.newInputStream(Path.of(this.source, new String[0]), new OpenOption[0]));
        return new TarArchiveInputStream((InputStream)(this.source.endsWith(".gz") ? new GzipCompressorInputStream((InputStream)bi) : bi));
    }

    private void extractTar() {
        try (ArchiveInputStream ais = this.getArchiveInputStream();){
            this.extractTar(ais);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("Error during processing " + this.source + " : " + e.getMessage()), (Throwable)e);
        }
    }

    private void extractTar(ArchiveInputStream archiveInputStream) throws IOException {
        ArchiveEntry entry;
        while ((entry = archiveInputStream.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (!entryName.endsWith(".jar")) continue;
            String name = entryName.substring(entryName.lastIndexOf(47) + 1);
            Path jarFile = Files.createTempFile(name.substring(0, name.length() - 4), ".jar", new FileAttribute[0]);
            Files.copy((InputStream)archiveInputStream, jarFile, StandardCopyOption.REPLACE_EXISTING);
            this.extractJar(jarFile);
            Files.delete(jarFile);
        }
    }

    private void writeBom() throws IOException {
        Model model = new Model();
        model.setModelVersion("4.0.0");
        model.setGroupId(this.groupId);
        model.setArtifactId(this.artifactId);
        model.setVersion(this.version);
        this.dependencies.values().forEach(arg_0 -> ((Model)model).addDependency(arg_0));
        try (BufferedWriter writer = Files.newBufferedWriter(Path.of(this.output, new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);){
            new MavenXpp3Writer().write((Writer)writer, model);
        }
    }
}

