/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.bom;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Sha1 {
    private static final char[] HEXITS = "0123456789abcdef".toCharArray();
    private static final int BUFFER_SIZE = 65536;
    private final MessageDigest digest;
    private final ByteBuffer byteBuffer = ByteBuffer.allocate(65536);

    public Sha1() throws NoSuchAlgorithmException {
        this.digest = MessageDigest.getInstance("SHA-1");
    }

    public static String encode(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte aByte : bytes) {
            int twoHexes = aByte & 0xFF;
            sb.append(HEXITS[twoHexes >>> 4]);
            sb.append(HEXITS[twoHexes & 0xF]);
        }
        return sb.toString();
    }

    public byte[] getChecksumBytes(Path path) throws IOException {
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            this.digest.reset();
            this.readStream(is);
            byte[] byArray = this.digest.digest();
            return byArray;
        }
    }

    public String getChecksum(Path path) throws IOException {
        return Sha1.encode(this.getChecksumBytes(path));
    }

    private void readStream(InputStream is) throws IOException {
        try (ReadableByteChannel byteChannel = Channels.newChannel(is);){
            int bytes;
            while ((bytes = byteChannel.read(this.byteBuffer)) >= 0) {
                this.byteBuffer.flip();
                this.digest.update(this.byteBuffer);
                this.byteBuffer.clear();
            }
        }
    }
}

