/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.bom;

import com.fasterxml.jackson.jr.ob.JSON;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import org.apache.maven.model.Dependency;

public class QueryCentral {
    private final HttpClient client = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(20L)).build();

    Dependency getDependency(Path jarPath, String sha1) throws IOException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create("https://central.sonatype.com/solrsearch/select?q=1:" + sha1)).build();
        HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
        String body = response.body();
        CentralWrapper wrapper = (CentralWrapper)JSON.std.beanFrom(CentralWrapper.class, (Object)body);
        List<CentralDoc> docs = wrapper.response.docs;
        return docs != null && !docs.isEmpty() ? this.bestMatch(jarPath, docs) : null;
    }

    private Dependency bestMatch(Path jarPath, List<CentralDoc> docs) {
        CentralDoc doc = docs.get(0);
        if (docs.size() > 1) {
            String name = jarPath.getFileName().toString();
            int dot = name.lastIndexOf(46);
            int dash = name.lastIndexOf(45, dot);
            String version = name.substring(dash + 1, dot);
            String artifactId = dash > 0 ? name.substring(0, dash) : name;
            int bestMatch = -1;
            for (CentralDoc d : docs) {
                int matchMetric = 0;
                if (d.getA().equals(artifactId)) {
                    ++matchMetric;
                }
                if (d.getV().equals(version)) {
                    ++matchMetric;
                }
                if (bestMatch >= matchMetric) continue;
                doc = d;
                bestMatch = matchMetric;
            }
        }
        Dependency dependency = new Dependency();
        dependency.setGroupId(doc.g);
        dependency.setArtifactId(doc.a);
        dependency.setVersion(doc.v);
        return dependency;
    }

    public static class CentralWrapper {
        private CentralResponse response;

        public CentralResponse getResponse() {
            return this.response;
        }

        public void setResponse(CentralResponse response) {
            this.response = response;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CentralWrapper)) {
                return false;
            }
            CentralWrapper other = (CentralWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CentralResponse this$response = this.getResponse();
            CentralResponse other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !((Object)this$response).equals(other$response));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CentralWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CentralResponse $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
            return result;
        }

        public String toString() {
            return "QueryCentral.CentralWrapper(response=" + this.getResponse() + ")";
        }
    }

    public static class CentralResponse {
        private List<CentralDoc> docs;

        public List<CentralDoc> getDocs() {
            return this.docs;
        }

        public void setDocs(List<CentralDoc> docs) {
            this.docs = docs;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CentralResponse)) {
                return false;
            }
            CentralResponse other = (CentralResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<CentralDoc> this$docs = this.getDocs();
            List<CentralDoc> other$docs = other.getDocs();
            return !(this$docs == null ? other$docs != null : !((Object)this$docs).equals(other$docs));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CentralResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<CentralDoc> $docs = this.getDocs();
            result = result * 59 + ($docs == null ? 43 : ((Object)$docs).hashCode());
            return result;
        }

        public String toString() {
            return "QueryCentral.CentralResponse(docs=" + this.getDocs() + ")";
        }
    }

    public static class CentralDoc {
        private String g;
        private String a;
        private String v;

        public String getG() {
            return this.g;
        }

        public String getA() {
            return this.a;
        }

        public String getV() {
            return this.v;
        }

        public void setG(String g) {
            this.g = g;
        }

        public void setA(String a) {
            this.a = a;
        }

        public void setV(String v) {
            this.v = v;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CentralDoc)) {
                return false;
            }
            CentralDoc other = (CentralDoc)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$g = this.getG();
            String other$g = other.getG();
            if (this$g == null ? other$g != null : !this$g.equals(other$g)) {
                return false;
            }
            String this$a = this.getA();
            String other$a = other.getA();
            if (this$a == null ? other$a != null : !this$a.equals(other$a)) {
                return false;
            }
            String this$v = this.getV();
            String other$v = other.getV();
            return !(this$v == null ? other$v != null : !this$v.equals(other$v));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CentralDoc;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $g = this.getG();
            result = result * 59 + ($g == null ? 43 : $g.hashCode());
            String $a = this.getA();
            result = result * 59 + ($a == null ? 43 : $a.hashCode());
            String $v = this.getV();
            result = result * 59 + ($v == null ? 43 : $v.hashCode());
            return result;
        }

        public String toString() {
            return "QueryCentral.CentralDoc(g=" + this.getG() + ", a=" + this.getA() + ", v=" + this.getV() + ")";
        }
    }
}

