/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.buildx.maven.plugin.cmdline;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.honton.chas.buildx.maven.plugin.buildx.ImageBuild;
import org.honton.chas.buildx.maven.plugin.cmdline.Buildx;

public class BuildxBuild
extends Buildx<BuildxBuild> {
    public BuildxBuild(ImageBuild goal, String builderName) {
        super(goal);
        this.addCmd("build");
        this.addParameter("--builder", builderName);
        if (goal.provenance != null) {
            this.addParameter("--provenance", goal.provenance);
        }
        if (goal.sbom) {
            this.addParameter("--sbom", "true");
        }
        this.addBuildArgs(goal.buildArguments);
    }

    private static Stream<String> splitList(List<String> stringList) {
        return stringList.stream().flatMap(p -> p != null ? Arrays.stream(p.split(",")) : Stream.of(new String[0])).map(String::strip).filter(p -> !p.isEmpty());
    }

    private static String removeTrailingSlash(String registry) {
        int idxOfLastChar = registry.length() - 1;
        return registry.charAt(idxOfLastChar) == '/' ? registry.substring(0, idxOfLastChar) : registry;
    }

    private static String removeLeadingSlash(String image) {
        return image.charAt(0) == '/' ? image.substring(1) : image;
    }

    private static String fqin(String image, String registry) {
        return BuildxBuild.removeTrailingSlash(registry) + "/" + BuildxBuild.removeLeadingSlash(image);
    }

    public BuildxBuild addBuildArgs(Map<String, String> buildArguments) {
        if (buildArguments != null) {
            buildArguments.forEach((k, v) -> this.addParameter("--build-arg", k + "=" + v));
        }
        return this;
    }

    private boolean addPlatforms(List<String> platforms) {
        String platformParam;
        if (platforms != null && !(platformParam = BuildxBuild.splitList(platforms).collect(Collectors.joining(","))).isEmpty()) {
            this.addParameter("--platform", platformParam);
            return true;
        }
        return false;
    }

    public BuildxBuild addPlatformsAndImage(List<String> platforms, List<String> registries, String image) {
        String param = this.addPlatforms(platforms) && this.isPodman ? "--manifest" : "--tag";
        this.addImages(param, registries, image);
        return this;
    }

    public BuildxBuild addPlatformAndImage(String platform, List<String> registries, String image) {
        this.addParameter("--platform", platform);
        this.addImages("--tag", registries, image);
        return this;
    }

    private void addImages(String param, List<String> registries, String image) {
        AtomicBoolean needTag = new AtomicBoolean(true);
        if (registries != null) {
            BuildxBuild.splitList(registries).forEach(registry -> {
                this.addParameter(param, BuildxBuild.fqin(image, registry));
                needTag.set(false);
            });
        }
        if (needTag.get()) {
            this.addParameter(param, image);
        }
    }

    public BuildxBuild addContainerfileAndCtx(String file, String context, Map<String, String> additional) {
        additional.forEach((k, v) -> this.addParameter("--build-context", k + "=" + v));
        if (file != null) {
            this.addParameter("--file", file);
        }
        this.addParameter(context);
        return this;
    }
}

