/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.buildx.maven.plugin.containerfile;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.buildx.maven.plugin.Containerfile;
import org.honton.chas.buildx.maven.plugin.config.LayerConfig;
import org.honton.chas.buildx.maven.plugin.config.ShellOrExecConfig;

@Mojo(name="containerfile", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class CreateContainerfile
extends Containerfile {
    @Parameter(property="buildx.from", required=true)
    String from;
    @Parameter
    ShellOrExecConfig cmd;
    @Parameter
    ShellOrExecConfig entrypoint;
    @Parameter
    List<LayerConfig> layers;
    @Parameter
    Map<String, String> labels;
    @Parameter
    Map<String, String> env;
    @Parameter(property="buildx.user")
    String user;
    @Parameter
    List<String> expose;
    @Parameter
    List<String> volumes;
    @Parameter(property="buildx.workdir")
    String workdir;

    @Override
    protected void doExecute() throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.from != null) {
            sb.append("FROM ").append(this.from).append('\n');
        }
        if (this.layers != null) {
            this.layers.forEach(l -> this.writeLayer(sb, (LayerConfig)l));
        }
        if (this.entrypoint != null) {
            this.writeShellOrExec(sb, "ENTRYPOINT ", this.entrypoint);
        }
        if (this.cmd != null) {
            this.writeShellOrExec(sb, "CMD ", this.cmd);
        }
        if (this.labels != null) {
            this.labels.forEach((k, v) -> sb.append("LABEL ").append((String)k).append("=\"").append((String)v).append("\"\n"));
        }
        if (this.env != null) {
            this.env.forEach((k, v) -> sb.append("ENV ").append((String)k).append('=').append((String)v).append('\n'));
        }
        if (this.expose != null) {
            this.expose.forEach(p -> sb.append("EXPOSE ").append((String)p).append('\n'));
        }
        if (this.volumes != null) {
            this.volumes.forEach(p -> sb.append("VOLUME ").append((String)p).append('\n'));
        }
        if (this.user != null) {
            sb.append("USER ").append(this.user).append('\n');
        }
        if (this.workdir != null) {
            sb.append("WORKDIR ").append(this.workdir).append('\n');
        }
        Path contextPath = Path.of(this.context, new String[0]);
        Files.createDirectories(contextPath, new FileAttribute[0]);
        Files.writeString(contextPath.resolve(this.containerFile()), (CharSequence)sb, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private void writeShellOrExec(StringBuilder sb, String directive, ShellOrExecConfig shellOrExec) {
        sb.append(directive);
        if (shellOrExec.exec != null) {
            sb.append('[');
            shellOrExec.exec.forEach(e -> sb.append('\"').append((String)e).append("\","));
            sb.setCharAt(sb.length() - 1, ']');
        } else if (shellOrExec.shell != null) {
            sb.append(shellOrExec.shell);
        }
        sb.append('\n');
    }

    private void writeLayer(StringBuilder sb, LayerConfig layer) {
        sb.append("COPY ");
        if (layer.context != null) {
            sb.append("--from=").append(layer.context).append(' ');
        }
        if (layer.chmod != null) {
            sb.append("--chmod=").append(layer.chmod).append(' ');
        }
        if (layer.chown != null) {
            sb.append("--chown=").append(layer.chown).append(' ');
        }
        layer.srcs.forEach(s -> sb.append('\"').append((String)s).append("\","));
        sb.setCharAt(sb.length() - 1, ' ');
        sb.append('\"').append(layer.dest).append("\"\n");
    }
}

