/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.buildx.maven.plugin.login;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.honton.chas.buildx.maven.plugin.ImageGoal;
import org.honton.chas.buildx.maven.plugin.cmdline.Cmd;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;

@Mojo(name="login", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true)
public class RegistryLogin
extends ImageGoal {
    @Parameter(property="buildx.registry", required=true)
    String registry;
    @Parameter(property="buildx.username")
    String username;
    @Parameter(property="buildx.password")
    String password;
    @Component(role=SecDispatcher.class, hint="default")
    private SecDispatcher securityDispatcher;
    @Parameter(defaultValue="${settings}", required=true, readonly=true)
    private Settings settings;

    @Override
    protected final void doExecute() throws MojoExecutionException {
        Server server = this.getAuthInfo();
        Object command = ((Cmd)((Cmd)((Cmd)((Cmd)new Cmd(this).addCmd("login")).addParameter("--username")).addParameter(server.getUsername())).addParameter("--password-stdin")).addParameter(this.registry);
        this.executeCommand((Cmd<?>)command, server.getPassword(), true);
    }

    private Server getAuthInfo() throws MojoExecutionException {
        Server server = this.settings.getServer(this.registry);
        if (server == null) {
            this.getLog().info((CharSequence)("No credentials for " + this.registry + " in settings.xml"));
            server = new Server();
        }
        this.ensure(() -> ((Server)server).getUsername(), arg_0 -> ((Server)server).setUsername(arg_0), this.username);
        if (this.ensure(() -> ((Server)server).getPassword(), arg_0 -> ((Server)server).setPassword(arg_0), this.password)) {
            if (this.securityDispatcher instanceof DefaultSecDispatcher) {
                ((DefaultSecDispatcher)this.securityDispatcher).setConfigurationFile("~/.m2/settings-security.xml");
            }
            try {
                server.setPassword(this.securityDispatcher.decrypt(server.getPassword()));
            }
            catch (SecDispatcherException e) {
                throw new MojoExecutionException("unable to decrypt password for " + this.registry, (Exception)((Object)e));
            }
        }
        return server;
    }

    private <T> boolean ensure(Supplier<T> getter, Consumer<T> setter, T fallback) throws MojoExecutionException {
        if (getter.get() != null) {
            return true;
        }
        if (fallback == null) {
            throw new MojoExecutionException("Missing username or password for " + this.registry);
        }
        setter.accept(fallback);
        return false;
    }
}

