/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.buildx.maven.plugin;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.buildx.maven.plugin.cmdline.Cmd;
import org.honton.chas.buildx.maven.plugin.cmdline.ExecHelper;
import org.honton.chas.buildx.maven.plugin.config.ConnectionCfg;

public abstract class ImageGoal
extends AbstractMojo
implements ConnectionCfg {
    @Parameter(property="buildx.cli", defaultValue="docker")
    public String cli;
    @Parameter(property="buildx.skip", defaultValue="false")
    boolean skip;
    private Path pwd;

    public final void execute() throws MojoFailureException, MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping image build");
        } else {
            try {
                this.pwd = Path.of("", new String[0]).toAbsolutePath();
                this.doExecute();
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                throw new MojoFailureException(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract void doExecute() throws MojoExecutionException, IOException, ExecutionException, InterruptedException;

    public int executeCommand(Cmd<?> generator, boolean throwOnError) throws MojoExecutionException {
        return this.executeCommand(generator, null, throwOnError);
    }

    protected int executeCommand(Cmd<?> generator, String stdin, boolean throwOnError) throws MojoExecutionException {
        return new ExecHelper(this).createAndWait(generator.getCommand(), stdin, throwOnError);
    }

    protected String shortestPath(Path dst) {
        if (!dst.isAbsolute()) {
            dst = dst.toAbsolutePath();
        }
        String relative = this.pwd.relativize(dst).toString();
        String absolute = dst.toString();
        if (absolute.length() < relative.length()) {
            return absolute;
        }
        return relative.isEmpty() ? "./" : relative;
    }

    @Override
    public String getCli() {
        return this.cli;
    }
}

