/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.buildx.maven.plugin.cmdline;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.honton.chas.buildx.maven.plugin.buildx.ImageBuild;
import org.honton.chas.buildx.maven.plugin.cmdline.Buildx;

public class BuildxBuild
extends Buildx<BuildxBuild> {
    public BuildxBuild(ImageBuild goal, String builderName) {
        super(goal);
        this.addCmd("build");
        this.addParameter("--builder", builderName);
        if (goal.provenance != null) {
            this.addParameter("--provenance", goal.provenance);
        }
        if (goal.sbom) {
            this.addParameter("--sbom", "true");
        }
        this.addBuildArgs(goal.buildArguments);
    }

    public BuildxBuild addBuildArgs(Map<String, String> buildArguments) {
        if (buildArguments != null) {
            buildArguments.forEach((k, v) -> this.addParameter("--build-arg", k + "=" + v));
        }
        return this;
    }

    private boolean addPlatforms(List<String> platforms) {
        if (platforms != null) {
            LinkedHashSet set = new LinkedHashSet();
            platforms.stream().flatMap(p -> p != null ? Arrays.stream(p.split(",")) : Stream.of(new String[0])).map(String::strip).filter(p -> !p.isEmpty()).forEach(set::add);
            if (!set.isEmpty()) {
                this.addParameter("--platform", String.join((CharSequence)",", set));
                return set.size() > 1;
            }
        }
        return false;
    }

    public BuildxBuild addPlatformsAndImage(List<String> platforms, String image) {
        String param = this.addPlatforms(platforms) && this.isPodman ? "--manifest" : "--tag";
        this.addParameter(param, image);
        return this;
    }

    public BuildxBuild addPlatformAndImage(String platform, String image) {
        this.addParameter("--platform", platform);
        this.addParameter("--tag", image);
        return this;
    }

    public BuildxBuild addContainerfileAndCtx(String file, String context, Map<String, String> additional) {
        additional.forEach((k, v) -> this.addParameter("--build-context", k + "=" + v));
        if (file != null) {
            this.addParameter("--file", file);
        }
        this.addParameter(context);
        return this;
    }
}

