package org.honton.chas.buildx.maven.plugin.cmdline;

import lombok.experimental.UtilityClass;

@UtilityClass
public class OperatingSystem {

  public String localCache(String path) {
    return path != null ? path : defaultCacheForOs();
  }

  private String defaultCacheForOs() {
    String osName = System.getProperty("os.name").toLowerCase();
    if (osName.contains("win")) {
      return System.getenv("LOCALAPPDATA") + "\\Docker";
    } else if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
      return "~/.cache/Docker";
    } else if (osName.contains("mac")) {
      return "~/Library/Caches/Docker";
    }
    return "target/cache/Docker";
  }
}
