/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.buildx.maven.plugin.buildx;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.buildx.maven.plugin.Containerfile;
import org.honton.chas.buildx.maven.plugin.cmdline.Buildx;
import org.honton.chas.buildx.maven.plugin.cmdline.BuildxBuild;

@Mojo(name="build", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class ImageBuild
extends Containerfile {
    public static final String BUILDX_MAVEN = "buildx-maven";
    @Parameter(property="buildx.image", required=true)
    protected String image;
    @Parameter(property="buildx.platforms")
    protected List<String> platforms;
    @Parameter
    public Map<String, String> buildArguments;
    @Parameter(property="buildx.builder", defaultValue="buildx-maven")
    protected String builder;
    @Parameter
    public Map<String, String> contexts;
    @Parameter(property="buildx.load", defaultValue="true")
    boolean load;
    @Parameter(property="buildx.provenance")
    public String provenance;
    @Parameter(property="buildx.sbom", defaultValue="false")
    public boolean sbom;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession session;

    static String imageNameHash(String image) {
        String canonical = ImageBuild.canonicalImage(image);
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        return Base64.getUrlEncoder().encodeToString(digest.digest(canonical.getBytes(StandardCharsets.UTF_8))).substring(0, 43);
    }

    static String canonicalImage(String image) {
        String[] parts = image.split("/");
        StringBuilder sb = new StringBuilder();
        if (parts.length == 1) {
            sb.append("docker.io");
        } else {
            String port;
            String registry = parts[0];
            int endIdx = registry.length();
            int colonIdx = registry.indexOf(58);
            if (colonIdx >= 0 && (port = registry.substring(colonIdx + 1)).equals("443")) {
                endIdx = colonIdx;
            }
            sb.append(registry, 0, endIdx);
        }
        sb.append("/");
        if (parts.length <= 2) {
            sb.append("library/");
        } else {
            for (int i = 1; i < parts.length - 1; ++i) {
                sb.append(parts[i]).append("/");
            }
        }
        String repository = parts[parts.length - 1];
        sb.append(repository);
        if (repository.indexOf(58) < 0) {
            sb.append(":latest");
        }
        return sb.toString();
    }

    static String nativePlatform() {
        return ImageBuild.operatingSystem() + "/" + ImageBuild.architecture();
    }

    static String operatingSystem() {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.contains("win") ? "windows" : "linux";
    }

    static String architecture() {
        String osArch;
        switch (osArch = System.getProperty("os.arch")) {
            case "aarch64": {
                return "arm64";
            }
            case "x86_64": {
                return "amd64";
            }
        }
        return osArch;
    }

    protected String ctxDir() {
        return this.shortestPath(Path.of(this.context, new String[0]));
    }

    protected Map<String, String> contexts() {
        if (this.contexts == null) {
            return Map.of();
        }
        return this.contexts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.shortestPath(Path.of((String)e.getValue(), new String[0]))));
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        if (BUILDX_MAVEN.equals(this.builder)) {
            Buildx createCmd = (Buildx)((Buildx)((Buildx)new Buildx(this).addCmd("create")).addParameter("--driver", "docker-container")).addParameter("--name", this.builder);
            this.executeCommand(createCmd, false);
        }
        String ctxDir = this.ctxDir();
        Map<String, String> additional = this.contexts();
        BuildxBuild buildCmd = new BuildxBuild(this, this.builder).addPlatformsAndImage(this.platforms, this.image).addContainerfileAndCtx(this.containerFile, ctxDir, additional);
        this.executeCommand(buildCmd, true);
        if (this.load) {
            this.loadImage(this.builder, ctxDir, additional);
        }
    }

    private void loadImage(String builderName, String ctxDir, Map<String, String> additional) throws MojoExecutionException {
        BuildxBuild buildCmd = ((BuildxBuild)new BuildxBuild(this, builderName).addPlatformAndImage(ImageBuild.nativePlatform(), this.image).addParameter("--output", "type=docker")).addContainerfileAndCtx(this.containerFile, ctxDir, additional);
        this.executeCommand(buildCmd, true);
    }
}

