/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.buildx.maven.plugin.cmdline;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.honton.chas.buildx.maven.plugin.ImageGoal;

public class ExecHelper {
    private final Consumer<String> infoLine;

    public ExecHelper(ImageGoal goal) {
        Log log = goal.getLog();
        this.infoLine = lineText -> {
            if (lineText != null) {
                log.info((CharSequence)lineText);
            }
        };
    }

    public int createAndWait(List<String> command, String stdin, boolean throwOnError) throws MojoExecutionException {
        try {
            this.infoLine.accept(String.join((CharSequence)" ", command));
            Process process = new ProcessBuilder(command).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
            OutputStream os = process.getOutputStream();
            if (stdin != null) {
                os.write(stdin.getBytes(StandardCharsets.UTF_8));
            }
            os.close();
            int exitCode = process.waitFor();
            if (exitCode != 0 && throwOnError) {
                throw new MojoExecutionException("command exited with error - " + exitCode);
            }
            return exitCode;
        }
        catch (IOException | InterruptedException ex) {
            throw new MojoExecutionException((Throwable)ex);
        }
    }
}

