/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import java.io.File;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.honton.chas.checkstats.Failure;
import org.honton.chas.checkstats.ProjectStats;
import org.honton.chas.checkstats.StandardStatistic;
import org.honton.chas.checkstats.Stat;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY)
public class CheckStatsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${project.build.directory}/stats.json", property="output", required=true)
    private File statsFile;

    public void execute() throws MojoExecutionException {
        try {
            this.doWork();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    public void doWork() throws MojoExecutionException {
        if (this.project.getPackaging().equals("pom")) {
            return;
        }
        ProjectStats currentStats = this.aggregateCurrentStats();
        currentStats.write(this.statsFile);
        Artifact attachement = this.getAttachmentArtifact("stats");
        ProjectStats priorStats = this.readAttachedStats(attachement);
        if (priorStats != null) {
            this.logFailures(priorStats.checkIsBetter(currentStats));
        }
        this.projectHelper.attachArtifact(this.project, attachement.getExtension(), attachement.getClassifier(), this.statsFile);
    }

    private void logFailures(List<Failure> failures) {
        for (Failure failure : failures) {
            this.getLog().error((CharSequence)failure.toString());
        }
        if (!failures.isEmpty()) {
            throw new MojoExecutionException("degraded statistics");
        }
    }

    private ProjectStats aggregateCurrentStats() {
        File srcDir = new File(this.project.getBuild().getSourceDirectory());
        File targetDir = new File(this.project.getBuild().getDirectory());
        ProjectStats stats = new ProjectStats();
        stats.addSrcFiles(srcDir);
        for (StandardStatistic standard : StandardStatistic.values()) {
            this.getLog().debug((CharSequence)("merging reportRootStat " + (Object)((Object)standard)));
            Stat stat = standard.read(this.getLog(), srcDir, targetDir);
            if (stat != null) {
                this.getLog().info((CharSequence)(standard.name() + " has " + stat.getSize() + " stats"));
                stats.addStat(standard.name(), stat);
                continue;
            }
            this.getLog().debug((CharSequence)"null reportRootStat");
        }
        return stats;
    }

    @Nonnull
    Artifact getAttachmentArtifact(@Nonnull String classifier) {
        return new DefaultArtifact(this.project.getGroupId(), this.project.getArtifactId(), classifier, this.project.getPackaging(), this.project.getVersion());
    }

    @Nullable
    ProjectStats readAttachedStats(@Nonnull Artifact artifact) {
        File statsFile = this.getArtifact(artifact);
        if (statsFile == null) {
            return null;
        }
        return ProjectStats.read(statsFile);
    }

    @Nullable
    File getArtifact(@Nonnull Artifact artifact) {
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(artifact);
        request.setRepositories(this.remoteRepos);
        this.getLog().info((CharSequence)("Resolving artifact " + artifact + " from " + this.remoteRepos));
        try {
            ArtifactResult result = this.repoSystem.resolveArtifact(this.repoSession, request);
            return result.getArtifact().getFile();
        }
        catch (ArtifactResolutionException are) {
            this.getLog().warn((CharSequence)("could not find " + artifact));
            return null;
        }
    }
}

