/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import java.io.File;
import javax.xml.stream.events.StartElement;
import org.honton.chas.checkstats.Stat;
import org.honton.chas.checkstats.XmlParser;

public class CheckstyleParser
extends XmlParser {
    CheckstyleParser(File srcDir) {
        super(srcDir);
    }

    @Override
    XmlParser.Element getRootElement() {
        return new RootElement();
    }

    private class FileElement
    extends XmlParser.Element {
        private final Stat fileStat;

        public FileElement(CheckstyleElement prior, String fileName) {
            super(prior);
            this.fileStat = CheckstyleParser.this.getFileStat(fileName, true);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (FileElement.isElementName(startElement, "error")) {
                String severity = FileElement.getAttributeValue(startElement, "severity");
                this.increment(severity);
            }
            return new XmlParser.Element(this);
        }

        private void increment(String value) {
            Number prior = this.fileStat.getNumber(value);
            this.fileStat.put(value, prior != null ? prior.intValue() + 1 : 1);
        }
    }

    private class CheckstyleElement
    extends XmlParser.Element {
        public CheckstyleElement(RootElement root) {
            super(root);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (CheckstyleElement.isElementName(startElement, "file")) {
                return new FileElement(this, CheckstyleElement.getAttributeValue(startElement, "name"));
            }
            return new XmlParser.Element(this);
        }
    }

    private class RootElement
    extends XmlParser.Element {
        public RootElement() {
            super(null);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (RootElement.isElementName(startElement, "checkstyle")) {
                return new CheckstyleElement(this);
            }
            throw new IllegalStateException("not expected <" + startElement.getName().getLocalPart() + "> at root");
        }
    }
}

