/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import java.io.File;
import javax.xml.stream.events.StartElement;
import org.honton.chas.checkstats.Stat;
import org.honton.chas.checkstats.XmlParser;

public class CpdParser
extends XmlParser {
    CpdParser(File srcDir) {
        super(srcDir);
    }

    @Override
    XmlParser.Element getRootElement() {
        return new RootElement();
    }

    private void incrementFileStat(String fileName) {
        Stat fileStat = this.getFileStat(fileName, true);
        CpdParser.incrementStat(fileStat, "copyPastes");
    }

    private class DuplicationElement
    extends XmlParser.Element {
        public DuplicationElement(CpdElement root) {
            super(root);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (DuplicationElement.isElementName(startElement, "file")) {
                CpdParser.this.incrementFileStat(DuplicationElement.getAttributeValue(startElement, "path"));
            }
            return new XmlParser.Element(this);
        }
    }

    private class CpdElement
    extends XmlParser.Element {
        public CpdElement(RootElement root) {
            super(root);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (CpdElement.isElementName(startElement, "duplication")) {
                return new DuplicationElement(this);
            }
            return new XmlParser.Element(this);
        }
    }

    private class RootElement
    extends XmlParser.Element {
        public RootElement() {
            super(null);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (RootElement.isElementName(startElement, "pmd-cpd")) {
                return new CpdElement(this);
            }
            throw new IllegalStateException("not expected <" + startElement.getName().getLocalPart() + "> at root");
        }
    }
}

