/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import java.io.File;
import javax.xml.stream.events.StartElement;
import org.honton.chas.checkstats.Stat;
import org.honton.chas.checkstats.XmlParser;

public class JacocoParser
extends XmlParser {
    JacocoParser(File srcDir) {
        super(srcDir);
    }

    @Override
    XmlParser.Element getRootElement() {
        return new RootElement();
    }

    private class SourceFileElement
    extends XmlParser.Element {
        private final Stat fileStat;

        public SourceFileElement(PackageElement prior, String fileName) {
            super(prior);
            this.fileStat = JacocoParser.this.getFileStat(fileName, false);
        }

        private void setStat(String type, int missed, int covered) {
            double numerator = missed;
            long denominator = (long)missed + (long)covered;
            this.fileStat.put(type, numerator / (double)denominator);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (SourceFileElement.isElementName(startElement, "counter")) {
                this.setStat(SourceFileElement.getAttributeValue(startElement, "type"), Integer.parseInt(SourceFileElement.getAttributeValue(startElement, "missed")), Integer.parseInt(SourceFileElement.getAttributeValue(startElement, "covered")));
            }
            return new XmlParser.Element(this);
        }
    }

    private class PackageElement
    extends XmlParser.Element {
        final String packageName;

        public PackageElement(ReportElement root, String packageName) {
            super(root);
            this.packageName = packageName;
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (PackageElement.isElementName(startElement, "sourcefile")) {
                return new SourceFileElement(this, this.packageName + "/" + PackageElement.getAttributeValue(startElement, "name"));
            }
            return new XmlParser.Element(this);
        }
    }

    private class ReportElement
    extends XmlParser.Element {
        public ReportElement(RootElement root) {
            super(root);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (ReportElement.isElementName(startElement, "package")) {
                return new PackageElement(this, ReportElement.getAttributeValue(startElement, "name"));
            }
            return new XmlParser.Element(this);
        }
    }

    private class RootElement
    extends XmlParser.Element {
        public RootElement() {
            super(null);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (RootElement.isElementName(startElement, "report")) {
                return new ReportElement(this);
            }
            throw new IllegalStateException("not expected <" + startElement.getName().getLocalPart() + "> at root");
        }
    }
}

