/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import java.io.File;
import javax.xml.stream.events.StartElement;
import org.honton.chas.checkstats.Stat;
import org.honton.chas.checkstats.XmlParser;

public class PmdParser
extends XmlParser {
    private static String[] PRIORITY_CLASS = new String[]{"", "critical", "likely", "confusing", "optional", "pedantic"};

    PmdParser(File srcDir) {
        super(srcDir);
    }

    @Override
    XmlParser.Element getRootElement() {
        return new RootElement();
    }

    private class FileElement
    extends XmlParser.Element {
        private final Stat fileStat;

        public FileElement(CpdElement prior, String fileName) {
            super(prior);
            this.fileStat = PmdParser.this.getFileStat(fileName, true);
        }

        private void incrementFileStat(String priority) {
            String key = PRIORITY_CLASS[Integer.parseInt(priority)];
            XmlParser.incrementStat(this.fileStat, key);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (FileElement.isElementName(startElement, "violation")) {
                this.incrementFileStat(FileElement.getAttributeValue(startElement, "priority"));
            }
            return new XmlParser.Element(this);
        }
    }

    private class CpdElement
    extends XmlParser.Element {
        public CpdElement(RootElement root) {
            super(root);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (CpdElement.isElementName(startElement, "file")) {
                return new FileElement(this, CpdElement.getAttributeValue(startElement, "name"));
            }
            return new XmlParser.Element(this);
        }
    }

    private class RootElement
    extends XmlParser.Element {
        public RootElement() {
            super(null);
        }

        @Override
        public XmlParser.Element push(StartElement startElement) {
            if (RootElement.isElementName(startElement, "pmd")) {
                return new CpdElement(this);
            }
            throw new IllegalStateException("not expected <" + startElement.getName().getLocalPart() + "> at root");
        }
    }
}

