/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.honton.chas.checkstats.Failure;
import org.honton.chas.checkstats.Stat;

public class ProjectStats {
    private Set<String> files = new TreeSet<String>();
    private Map<String, Stat> stats = new HashMap<String, Stat>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectStats read(File file) {
        ProjectStats projectStats;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        try {
            Gson gson = ProjectStats.getGson();
            projectStats = (ProjectStats)gson.fromJson((Reader)reader, ProjectStats.class);
        }
        catch (Throwable throwable) {
            ((Reader)reader).close();
            throw throwable;
        }
        ((Reader)reader).close();
        return projectStats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file) {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            Gson gson = ProjectStats.getGson();
            gson.toJson((Object)this, (Appendable)writer);
        }
    }

    public void addSrcFiles(File srcDir) {
        srcDir.listFiles(new FileFilter(){
            final StringBuilder sb = new StringBuilder();

            @Override
            public boolean accept(File file) {
                int length = this.sb.length();
                this.sb.append(file.getName());
                if (file.isDirectory()) {
                    this.sb.append('/');
                    file.listFiles(this);
                } else {
                    ProjectStats.this.files.add(this.sb.toString());
                }
                this.sb.setLength(length);
                return false;
            }
        });
    }

    private static Gson getGson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson;
    }

    @Nonnull
    public List<Failure> checkIsBetter(@Nonnull ProjectStats current) {
        Stat.Context context = new Stat.Context(this.files);
        for (Map.Entry<String, Stat> entry : current.stats.entrySet()) {
            Stat priorValue = this.stats.get(entry.getKey());
            if (priorValue == null) continue;
            Stat currentValue = entry.getValue();
            priorValue.checkIsBetter(currentValue, context);
        }
        return context.getFailures();
    }

    public int getSize() {
        return this.stats.size();
    }

    void addStat(String name, Stat stat) {
        this.stats.put(name, stat);
    }

    void addFile(String fileName) {
        this.files.add(fileName);
    }

    public Set<String> getFiles() {
        return this.files;
    }

    public Map<String, Stat> getStats() {
        return this.stats;
    }

    public void setFiles(Set<String> files) {
        this.files = files;
    }

    public void setStats(Map<String, Stat> stats) {
        this.stats = stats;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectStats)) {
            return false;
        }
        ProjectStats other = (ProjectStats)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$files = this.getFiles();
        Set<String> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        Map<String, Stat> this$stats = this.getStats();
        Map<String, Stat> other$stats = other.getStats();
        return !(this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectStats;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        Map<String, Stat> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectStats(files=" + this.getFiles() + ", stats=" + this.getStats() + ")";
    }
}

