/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import java.io.File;
import org.apache.maven.plugin.logging.Log;
import org.honton.chas.checkstats.CheckstyleParser;
import org.honton.chas.checkstats.CpdParser;
import org.honton.chas.checkstats.FindbugsParser;
import org.honton.chas.checkstats.JacocoParser;
import org.honton.chas.checkstats.PmdParser;
import org.honton.chas.checkstats.Stat;
import org.honton.chas.checkstats.XmlParser;

public enum StandardStatistic {
    Checkstyle("checkstyle-result.xml"){

        @Override
        XmlParser createXmlParser(File srcDir) {
            return new CheckstyleParser(srcDir);
        }
    }
    ,
    Cpd("cpd.xml"){

        @Override
        XmlParser createXmlParser(File srcDir) {
            return new CpdParser(srcDir);
        }
    }
    ,
    Pmd("pmd.xml"){

        @Override
        XmlParser createXmlParser(File srcDir) {
            return new PmdParser(srcDir);
        }
    }
    ,
    Findbugs("findbugsXml.xml"){

        @Override
        XmlParser createXmlParser(File srcDir) {
            return new FindbugsParser(srcDir);
        }
    }
    ,
    JaCoCo("site/jacoco/jacoco.xml"){

        @Override
        XmlParser createXmlParser(File srcDir) {
            return new JacocoParser(srcDir);
        }
    };

    private final String reportName;

    abstract XmlParser createXmlParser(File var1);

    private StandardStatistic(String reportName) {
        this.reportName = reportName;
    }

    public Stat read(Log log, File srcDir, File targetDir) {
        File reportFile = new File(targetDir, this.reportName);
        if (reportFile.isFile()) {
            return this.createXmlParser(srcDir).summarize(reportFile);
        }
        log.info((CharSequence)(this.name() + " report (" + reportFile.getCanonicalPath() + ") was not found"));
        return null;
    }
}

