/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.honton.chas.checkstats.Failure;

@JsonAdapter(value=Adapter.class)
public class Stat {
    private final Map<String, Object> values = new HashMap<String, Object>();
    private static ConstantStat MAX_VALUES = new ConstantStat(Integer.MAX_VALUE, (Double)Double.MAX_VALUE);
    private static ConstantStat ZEROS = new ConstantStat(0, 0.0);

    public boolean put(@Nonnull String name, @Nonnull Number value) {
        return this.values.put(name, value) == null;
    }

    public boolean put(@Nonnull String name, @Nonnull Stat value) {
        return this.values.put(name, value) == null;
    }

    public Stat getStat(String key) {
        return (Stat)this.values.get(key);
    }

    public Number getNumber(String key) {
        return (Number)this.values.get(key);
    }

    Object getEffectivePrior(Context context, Map.Entry<String, Object> entry) {
        Object value = this.values.get(entry.getKey());
        if (value != null) {
            return value;
        }
        return context.getEffectivePrior(entry);
    }

    private void checkSingleValueIsBetter(Context context, Map.Entry<String, Object> entry) {
        Object priorValue = this.getEffectivePrior(context, entry);
        if (priorValue == null) {
            return;
        }
        Object currentValue = entry.getValue();
        if (currentValue instanceof Stat) {
            ((Stat)priorValue).checkIsBetter((Stat)currentValue, context);
        } else {
            Number cv = (Number)currentValue;
            Number pv = (Number)priorValue;
            int cmp = cv instanceof Double || pv instanceof Double ? Double.compare(cv.doubleValue(), pv.doubleValue()) : Integer.compare(cv.intValue(), pv.intValue());
            if (cmp > 0) {
                context.addFailure(cv, pv);
            }
        }
    }

    void checkIsBetter(@Nonnull Stat current, @Nonnull Context context) {
        context.pushLevel();
        for (Map.Entry<String, Object> entry : current.values.entrySet()) {
            context.setName(entry.getKey());
            this.checkSingleValueIsBetter(context, entry);
        }
        context.popLevel();
    }

    @Nonnull
    List<Failure> checkIsBetter(@Nonnull Stat current) {
        Context context = new Context(Collections.emptySet());
        this.checkIsBetter(current, context);
        return context.getFailures();
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Stat) {
            return this.values.equals(((Stat)obj).values);
        }
        return false;
    }

    public String toString() {
        return this.values.toString();
    }

    public int getSize() {
        return this.values.size();
    }

    public static class Adapter
    extends TypeAdapter<Stat> {
        public void write(JsonWriter out, Stat stat) throws IOException {
            out.beginObject();
            for (Map.Entry entry : stat.values.entrySet()) {
                out.name((String)entry.getKey());
                Object value = entry.getValue();
                if (value instanceof Stat) {
                    this.write(out, (Stat)value);
                    continue;
                }
                if (value instanceof Integer) {
                    out.value((long)((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    out.value(((Double)value).doubleValue());
                    continue;
                }
                throw new IllegalStateException(value.getClass().getCanonicalName() + " is not supported");
            }
            out.endObject();
        }

        static Number stringToNumber(String value) {
            if (value.indexOf(46) < 0) {
                return new Integer(value);
            }
            return new Double(value);
        }

        public Stat read(JsonReader in) throws IOException {
            Stat stat = new Stat();
            in.beginObject();
            while (in.hasNext()) {
                String name = in.nextName();
                JsonToken value = in.peek();
                if (value == JsonToken.BEGIN_OBJECT) {
                    stat.put(name, this.read(in));
                    continue;
                }
                String number = in.nextString();
                stat.put(name, Adapter.stringToNumber(number));
            }
            in.endObject();
            return stat;
        }
    }

    static class Context {
        private final Set<String> files;
        private final StringBuilder sb = new StringBuilder();
        private final List<Failure> failures = new ArrayList<Failure>();
        State state = new State(null, 0, 0);

        void pushLevel() {
            int length = this.sb.length();
            if (length > 0) {
                this.sb.append('.');
                ++length;
            }
            this.state = this.state.push(length);
        }

        public Object getEffectivePrior(Map.Entry<String, Object> entry) {
            if (this.state.depth != 1) {
                return null;
            }
            ConstantStat constantStat = this.files.contains(entry.getKey()) ? ZEROS : MAX_VALUES;
            return constantStat.getEffectivePrior(this, entry);
        }

        void setName(String name) {
            this.sb.setLength(this.state.length);
            this.sb.append(name);
        }

        void addFailure(Number cv, Number pv) {
            this.failures.add(new Failure(this.sb.toString(), cv, pv));
        }

        void popLevel() {
            this.state = this.state.prior;
        }

        @ConstructorProperties(value={"files"})
        public Context(Set<String> files) {
            this.files = files;
        }

        public List<Failure> getFailures() {
            return this.failures;
        }
    }

    static class State {
        private final State prior;
        private final int depth;
        private final int length;

        public State push(int length) {
            return new State(this, this.depth + 1, length);
        }

        private State(State prior, int depth, int length) {
            this.prior = prior;
            this.depth = depth;
            this.length = length;
        }
    }

    private static class ConstantStat
    extends Stat {
        private final Integer intConstant;
        private final Double doubleConstant;

        @Override
        Object getEffectivePrior(Context context, Map.Entry<String, Object> entry) {
            Object currentValue = entry.getValue();
            if (currentValue instanceof Stat) {
                return this;
            }
            if (currentValue instanceof Integer) {
                return this.intConstant;
            }
            if (currentValue instanceof Double) {
                return this.doubleConstant;
            }
            throw new IllegalStateException("unsupported type " + currentValue.getClass().getCanonicalName());
        }

        @ConstructorProperties(value={"intConstant", "doubleConstant"})
        public ConstantStat(Integer intConstant, Double doubleConstant) {
            this.intConstant = intConstant;
            this.doubleConstant = doubleConstant;
        }
    }
}

