/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.checkstats;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.honton.chas.checkstats.Stat;

public abstract class XmlParser {
    static final XMLInputFactory factory = XMLInputFactory.newInstance();
    private final Stat reportRootStat = new Stat();
    private final Path root;

    XmlParser(File srcDir) {
        this.root = srcDir.toPath();
    }

    private String resolve(String name) {
        return this.root.relativize(new File(name).toPath()).toString();
    }

    Stat getFileStat(String filename, boolean resolve) {
        Stat stat;
        if (resolve) {
            filename = this.resolve(filename);
        }
        if ((stat = this.reportRootStat.getStat(filename)) == null) {
            stat = new Stat();
            this.reportRootStat.put(filename, stat);
        }
        return stat;
    }

    static void incrementStat(Stat stat, String key) {
        Number prior = stat.getNumber(key);
        stat.put(key, prior != null ? prior.intValue() + 1 : 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat summarize(File file) {
        Stat stat;
        FileInputStream is = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)is, StandardCharsets.UTF_8);
        XMLEventReader eventReader = factory.createXMLEventReader(reader);
        try {
            this.processFile(eventReader, this.getRootElement());
            stat = this.reportRootStat;
        }
        catch (Throwable throwable) {
            eventReader.close();
            throw throwable;
        }
        eventReader.close();
        return stat;
    }

    abstract Element getRootElement();

    private void processFile(XMLEventReader eventReader, Element current) {
        while (eventReader.hasNext()) {
            XMLEvent event = eventReader.nextEvent();
            switch (event.getEventType()) {
                case 1: {
                    StartElement startElement = event.asStartElement();
                    current = current.push(startElement);
                    break;
                }
                case 2: {
                    current = current.pop();
                }
            }
        }
    }

    static class Element {
        private final Element prior;

        public Element(Element prior) {
            this.prior = prior;
        }

        public Element push(StartElement startElement) {
            return new Element(this);
        }

        public Element pop() {
            return this.prior;
        }

        static boolean isElementName(StartElement startElement, String name) {
            return startElement.getName().getLocalPart().equals(name);
        }

        static String getAttributeValue(StartElement startElement, String name) {
            Attribute attribute = startElement.getAttributeByName(new QName(name));
            return attribute != null ? attribute.getValue() : null;
        }
    }
}

