/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.honton.chas.compose.maven.plugin.ComposeGoal;

@Mojo(name="assemble", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ComposeAssemble
extends ComposeGoal {
    @Parameter(defaultValue="true")
    boolean attach;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Component
    MavenProjectHelper projectHelper;
    @Parameter(property="compose.src", defaultValue="src/compose")
    File composeSrc;
    Path composeSrcPath;

    private static Manifest createManifest() {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(new Attributes.Name("Created-By"), "compose-maven-plugin");
        mainAttributes.put(Attributes.Name.CONTENT_TYPE, "Compose");
        return manifest;
    }

    private void jarFiles(JarOutputStream jarStream, Path jarPath, Path current) throws IOException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(current, Files::isReadable);){
            for (Path path : files) {
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                JarEntry entry = new JarEntry(jarPath.resolve(path.getFileName()).toString());
                entry.setTime(path.toFile().lastModified());
                jarStream.putNextEntry(entry);
                Files.copy(path, jarStream);
                jarStream.closeEntry();
            }
        }
    }

    @Override
    protected final void doExecute() throws IOException {
        this.composeSrcPath = this.composeSrc.toPath();
        this.composeBuildPath = Files.createDirectories(this.composeBuildDirectory.toPath(), new FileAttribute[0]);
        int count = this.jarAndAttach("compose", Path.of(this.project.getArtifactId(), new String[0]), this.composeSrcPath);
        if (this.composeSrc.isDirectory()) {
            this.composeSrcPath = this.composeSrc.toPath();
            try (Stream<Path> services = Files.list(this.composeSrcPath);){
                count += services.mapToInt(p -> {
                    Path servicePath = p.getFileName();
                    return this.jarAndAttach(servicePath.toString(), servicePath, (Path)p);
                }).sum();
            }
        }
        if (count == 0) {
            this.getLog().info((CharSequence)"No compose files found");
        }
    }

    private int jarAndAttach(String classifier, Path servicePath, Path path) {
        if (!Files.isReadable(path.resolve("compose.yaml"))) {
            return 0;
        }
        Path destPath = this.composeBuildPath.resolve(servicePath + ".jar");
        try (JarOutputStream destination = new JarOutputStream(Files.newOutputStream(destPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), ComposeAssemble.createManifest());){
            this.jarFiles(destination, servicePath, path);
        }
        if (this.attach) {
            this.projectHelper.attachArtifact(this.project, "jar", classifier, destPath.toFile());
        }
        return 1;
    }
}

