/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.InterpolatorFilterReader;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeProjectGoal;
import org.honton.chas.compose.maven.plugin.InterpolatorFactory;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="link", defaultPhase=LifecyclePhase.TEST, threadSafe=true)
public class ComposeLink
extends ComposeProjectGoal {
    private final Interpolator interpolator;
    private final Yaml yaml;
    private final Map<String, String> extractedPaths = new HashMap<String, String>();
    private final Set<Path> createdDirs = new HashSet<Path>();
    private final Set<String> hostMounts = new HashSet<String>();
    @Parameter
    List<String> dependencies;
    @Parameter
    List<Map<String, String>> variablePorts = new ArrayList<Map<String, String>>();
    @Parameter(defaultValue="true")
    boolean filter;
    @Parameter(defaultValue="${project.build.directory}/compose/", required=true, readonly=true)
    File composeProjectDir;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;

    @Inject
    public ComposeLink(MavenSession session, MavenProject project) {
        this.interpolator = InterpolatorFactory.createInterpolator(session, project);
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setDefaultScalarStyle(DumperOptions.ScalarStyle.PLAIN);
        this.yaml = new Yaml(options);
    }

    private static BufferedWriter bufferedWriter(Path dstPath) throws IOException {
        return Files.newBufferedWriter(dstPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static String removeJarSuffix(String serviceName) {
        return serviceName.substring(0, serviceName.lastIndexOf(46));
    }

    @Override
    public String subCommand() {
        return "config";
    }

    private File fetchArtifact(Artifact artifact) {
        Artifact local = this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest(artifact, this.remoteRepos, null)).getArtifact();
        if (local == null) {
            throw new MojoExecutionException(artifact + " is not available");
        }
        this.getLog().info((CharSequence)(artifact + " cache location " + local.getFile()));
        return local.getFile();
    }

    private void addDependency(CommandBuilder builder, String dependency) {
        DefaultArtifact artifact = new DefaultArtifact(dependency);
        if ("".equals(artifact.getClassifier())) {
            artifact = new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "compose", "jar", artifact.getVersion());
        }
        String gav = artifact.toString();
        this.getLog().info((CharSequence)("Adding dependency " + gav));
        this.addArtifact(builder, gav, this.fetchArtifact((Artifact)artifact));
    }

    private void addArtifact(CommandBuilder builder, String gav, File localFile) {
        try (JarFile jar = new JarFile(localFile);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String name = jarEntry.getName();
                if (name.endsWith("/") || name.startsWith("META-INF/")) continue;
                String priorGav = this.extractedPaths.put(name, gav);
                if (priorGav != null) {
                    throw new MojoExecutionException(jarEntry.getName() + " in " + gav + " was previously defined in " + priorGav);
                }
                Path dstPath = this.composeProjectDir.toPath().resolve(Path.of(name, new String[0]));
                Path parent = dstPath.getParent();
                if (this.createdDirs.add(parent)) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                InputStream source = jar.getInputStream(jarEntry);
                try {
                    this.copyYaml(source, dstPath);
                    if (name.endsWith("/compose.yaml")) {
                        builder.addGlobalOption("-f", dstPath.toString());
                        continue;
                    }
                    if (!name.endsWith("/.env")) continue;
                    builder.addGlobalOption("--env-file", dstPath.toString());
                }
                finally {
                    if (source == null) continue;
                    source.close();
                }
            }
        }
    }

    private void copyYaml(InputStream source, Path dstPath) throws IOException {
        Reader reader = this.interpolateReader(source);
        try (BufferedWriter writer = ComposeLink.bufferedWriter(dstPath);){
            String name = dstPath.getFileName().toString();
            if (name.endsWith(".yaml") || name.endsWith(".yml") || name.endsWith(".json")) {
                Map model = (Map)this.yaml.load(reader);
                this.replaceVariablePorts(model);
                this.yaml.dump((Object)model, (Writer)writer);
            } else {
                reader.transferTo(writer);
            }
        }
    }

    private void replaceVariablePorts(Map<String, Object> model) {
        Map services = (Map)model.get("services");
        if (services != null) {
            services.forEach(this::replaceVariablePorts);
            services.forEach(this::collectHostMounts);
        }
    }

    private void replaceVariablePorts(String serviceName, Map<String, Object> serviceDefinition) {
        List ports = (List)serviceDefinition.get("ports");
        if (ports != null) {
            List<Object> replacement = ports.stream().map(port -> this.getReplacement(serviceName, port)).toList();
            serviceDefinition.put("ports", replacement);
        }
    }

    private Object getReplacement(String serviceName, Object port) {
        if (port instanceof String) {
            String shortForm = (String)port;
            return this.shortFormReplacement(serviceName, shortForm);
        }
        if (port instanceof Map) {
            Map longForm = (Map)port;
            return this.longFormReplacement(serviceName, longForm);
        }
        return port;
    }

    private String shortFormReplacement(String serviceName, String shortForm) {
        String host;
        String[] parts = shortForm.split(":");
        if (parts.length > 1 && !(host = parts[parts.length - 2]).isEmpty() && !Character.isDigit(host.charAt(0))) {
            String container;
            String replacement = parts[parts.length - 1];
            int slashIdx = replacement.indexOf(47);
            String string = container = slashIdx < 0 ? replacement : replacement.substring(0, slashIdx);
            if (container.indexOf(45) >= 0) {
                throw new IllegalArgumentException("range not supported for variable port");
            }
            this.addVariablePort(serviceName, host, container);
            return replacement;
        }
        return shortForm;
    }

    private Map<?, ?> longFormReplacement(String serviceName, Map<?, ?> longForm) {
        Object container;
        String published;
        Object obj = longForm.get("published");
        if (obj instanceof String && !(published = (String)obj).isEmpty() && !Character.isDigit(published.charAt(0)) && (container = longForm.get("target")) != null) {
            this.addVariablePort(serviceName, published, container.toString());
            longForm.remove("published");
        }
        return longForm;
    }

    private void addVariablePort(String serviceName, String property, String container) {
        this.variablePorts.add(Map.of("service", serviceName, "property", property, "container", container));
    }

    private void collectHostMounts(String serviceName, Map<String, Object> model) {
        List volumes = (List)model.get("volumes");
        if (volumes != null) {
            volumes.forEach(this::collectHostMount);
        }
    }

    private void collectHostMount(Object volume) {
        String shortSyntax;
        int colonIdx;
        if (volume instanceof Map) {
            Object v;
            Map longSyntax = (Map)volume;
            if ("bind".equals(longSyntax.get("type")) && (v = longSyntax.get("source")) instanceof String) {
                String source = (String)v;
                this.collectVolume(source);
            }
        } else if (volume instanceof String && (colonIdx = (shortSyntax = (String)volume).indexOf(58)) >= 0) {
            this.collectVolume(shortSyntax.substring(0, colonIdx));
        }
    }

    private void collectVolume(String volume) {
        char isPath;
        if (!(volume.isEmpty() || (isPath = volume.charAt(0)) != '/' && isPath != '.')) {
            this.hostMounts.add(volume);
        }
    }

    private Reader interpolateReader(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return this.filter ? new InterpolatorFilterReader((Reader)reader, this.interpolator) : reader;
    }

    @Override
    protected void addComposeOptions(CommandBuilder builder) {
        if (this.dependencies != null) {
            this.dependencies.forEach(dependency -> this.addDependency(builder, (String)dependency));
        }
        this.composeBuildPath = this.composeBuildDirectory.toPath();
        if (Files.isDirectory(this.composeBuildPath, new LinkOption[0])) {
            this.addLocalServiceJars(builder);
        }
        builder.addGlobalOption("--project-directory", this.composeProjectDir.getAbsolutePath()).addOption("--no-interpolate").addOption("-o", this.linkedCompose.getPath());
    }

    private void addLocalServiceJars(CommandBuilder builder) {
        try (Stream<Path> services = Files.list(this.composeBuildPath);){
            services.forEach(localJar -> {
                String serviceName;
                if (Files.isRegularFile(localJar, new LinkOption[0]) && (serviceName = localJar.getFileName().toString()).endsWith(".jar")) {
                    String gav = this.project.getGroupId() + ":" + this.project.getArtifactId() + "::" + ComposeLink.removeJarSuffix(serviceName) + ":" + this.project.getVersion();
                    this.getLog().info((CharSequence)("Adding artifact " + gav));
                    this.addArtifact(builder, gav, localJar.toFile());
                }
            });
        }
    }

    @Override
    protected void postComposeCommand() {
        block18: {
            Path hostMountsPath = this.mountsFile.toPath();
            if (this.hostMounts.isEmpty()) {
                Files.deleteIfExists(hostMountsPath);
            } else {
                try (BufferedWriter bw = ComposeLink.bufferedWriter(hostMountsPath);){
                    this.yaml.dump((Object)this.hostMounts.toArray(), (Writer)bw);
                }
            }
            Path portsPath = this.portsFile.toPath();
            if (this.variablePorts.isEmpty()) {
                Files.deleteIfExists(portsPath);
                break block18;
            }
            try (BufferedWriter bw = ComposeLink.bufferedWriter(portsPath);){
                this.yaml.dump(this.variablePorts, (Writer)bw);
            }
        }
    }
}

