/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeProjectGoal;
import org.honton.chas.compose.maven.plugin.ExecHelper;
import org.honton.chas.compose.maven.plugin.PortInfo;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="up", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST, threadSafe=true)
public class ComposeUp
extends ComposeProjectGoal {
    private static final String ALL_INTERFACES = "0.0.0.0:";
    private static final int ALL_INTERFACES_LEN = "0.0.0.0:".length();
    @Parameter
    Map<String, String> env;
    @Parameter(defaultValue="${project.properties}", required=true, readonly=true)
    Properties properties;
    @Parameter(defaultValue="${project.build.directory}/compose/.env", required=true, readonly=true)
    File envFile;

    @Override
    protected String subCommand() {
        return "up";
    }

    @Override
    protected void addComposeOptions(CommandBuilder builder) {
        this.createHostSourceDirs();
        if (this.env != null && !this.env.isEmpty()) {
            this.createEnvFile();
            builder.addGlobalOption("--env-file", this.envFile.getPath());
        }
        builder.addGlobalOption("-f", this.linkedCompose.getPath()).addOption("--renew-anon-volumes").addOption("--remove-orphans").addOption("--pull", "missing").addOption("--quiet-pull").addOption("--wait").addOption("--wait-timeout", Integer.toString(this.timeout));
    }

    private void createEnvFile() {
        try (BufferedWriter writer = Files.newBufferedWriter(this.envFile.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.env.forEach((k, v) -> {
                try {
                    writer.append((CharSequence)k).append('=').append((CharSequence)v).append(System.lineSeparator());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
    }

    private void createHostSourceDirs() throws IOException {
        Path mountsPath = this.mountsFile.toPath();
        if (Files.isReadable(mountsPath)) {
            this.readMounts(mountsPath).forEach(this::createSourceDirectory);
        }
    }

    private void createSourceDirectory(String location) {
        Path path = Path.of(location, new String[0]);
        if (!path.isAbsolute()) {
            path = this.linkedCompose.toPath().getParent().resolve(location).normalize();
        }
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)("Unable to create directory " + path), (Throwable)e);
            }
        }
    }

    private List<String> readMounts(Path mountsPath) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(mountsPath);){
            List list = (List)new Yaml().load((Reader)reader);
            return list;
        }
    }

    @Override
    protected void postComposeCommand() {
        Path portsPath = this.portsFile.toPath();
        if (Files.isReadable(portsPath)) {
            this.readPorts(portsPath).forEach(this::assignMavenVariable);
        }
    }

    private List<PortInfo> readPorts(Path portsPath) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(portsPath);){
            List portsList = (List)new Yaml().load((Reader)reader);
            List<PortInfo> list = portsList.stream().map(port -> new PortInfo((String)port.get("property"), (String)port.get("service"), (String)port.get("container"))).toList();
            return list;
        }
    }

    private void assignMavenVariable(PortInfo portInfo) {
        CommandBuilder builder = this.createBuilder("port");
        builder.addOption(portInfo.getService(), portInfo.getContainer());
        String port = new ExecHelper(this.getLog()).outputAsString(this.timeout, builder).strip();
        if (port.startsWith(ALL_INTERFACES)) {
            port = port.substring(ALL_INTERFACES_LEN);
        }
        this.getLog().info((CharSequence)("Setting " + portInfo.getProperty() + " to " + port));
        this.properties.put(portInfo.getProperty(), port);
    }
}

