/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.logging.Log;
import org.honton.chas.compose.maven.plugin.CommandBuilder;

public class ExecHelper {
    private static final Pattern WARNING = Pattern.compile("\\[?(warning)]?:? ?(.+)", 2);
    private static final Pattern ERROR = Pattern.compile("\\[?(error)]?:? ?(.+)", 2);
    private final ExecutorCompletionService<Object> completionService;
    private final Consumer<CharSequence> debugLine;
    private final Consumer<CharSequence> infoLine;
    private final Consumer<CharSequence> errorLine;
    private final StringBuilder errorOutput = new StringBuilder();

    public ExecHelper(Log log) {
        this.debugLine = lineText -> {
            if (lineText != null) {
                log.debug(lineText);
            }
        };
        this.infoLine = lineText -> {
            if (lineText != null) {
                log.info(lineText);
            }
        };
        this.errorLine = lineText -> {
            if (lineText != null) {
                this.errorOutput.append((CharSequence)lineText);
                Matcher warning = WARNING.matcher((CharSequence)lineText);
                if (warning.matches()) {
                    log.warn((CharSequence)warning.group(2));
                } else {
                    Matcher error = ERROR.matcher((CharSequence)lineText);
                    if (error.matches()) {
                        log.error((CharSequence)error.group(2));
                    } else {
                        log.info(lineText);
                    }
                }
            }
        };
        this.completionService = new ExecutorCompletionService(new ScheduledThreadPoolExecutor(1));
    }

    public void createProcess(CommandBuilder builder, String stdin, Consumer<CharSequence> stdout, Consumer<CharSequence> stderr) {
        try {
            if (stdout != null) {
                builder.addGlobalOption("--ansi", "never");
            }
            List<String> command = builder.getCommand();
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            String cmdLine = String.join((CharSequence)" ", command);
            if (stdout == null) {
                processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
                this.infoLine.accept(cmdLine);
            } else {
                this.debugLine.accept(cmdLine);
            }
            if (stderr == null) {
                processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            }
            Process process = processBuilder.start();
            this.startPump(process.getInputStream(), stdout);
            this.startPump(process.getErrorStream(), stderr);
            OutputStream os = process.getOutputStream();
            if (stdin != null) {
                os.write(stdin.getBytes(StandardCharsets.UTF_8));
            }
            os.close();
            this.completionService.submit(process::waitFor);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private void startPump(InputStream process, Consumer<CharSequence> std) {
        if (process != null) {
            this.completionService.submit(() -> this.pumpLog(process, std));
        }
    }

    private Void pumpLog(InputStream is, Consumer<CharSequence> lineConsumer) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(is, StandardCharsets.UTF_8);){
            StringBuilder sb = new StringBuilder();
            while (true) {
                int i;
                if ((i = reader.read()) < 0) {
                    if (!sb.isEmpty()) {
                        lineConsumer.accept(sb);
                    }
                    Void void_ = null;
                    return void_;
                }
                if (i == 10) {
                    lineConsumer.accept(sb);
                    sb.setLength(0);
                    continue;
                }
                sb.append((char)i);
            }
        }
    }

    public void waitNoError(int secondsToWait) {
        int exitCode = this.waitForResult(secondsToWait);
        if (exitCode != 0) {
            throw new IllegalStateException("command exited with error - " + exitCode);
        }
    }

    public int waitForResult(int secondsToWait) {
        long timeToGo = TimeUnit.SECONDS.toMillis(secondsToWait);
        long endTime = System.currentTimeMillis() + timeToGo;
        try {
            do {
                Object taskExit;
                Future<Object> poll;
                if ((poll = this.completionService.poll(timeToGo, TimeUnit.MILLISECONDS)) == null || !((taskExit = poll.get()) instanceof Integer)) continue;
                Integer exit = (Integer)taskExit;
                return exit;
            } while ((timeToGo = endTime - System.currentTimeMillis()) > 0L);
            throw new IllegalStateException("timed out");
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String outputAsString(int secondsToWait, CommandBuilder builder) {
        StringBuilder sb = new StringBuilder();
        Consumer<CharSequence> consumer = l -> sb.append((CharSequence)l).append('\n');
        this.outputToConsumer(secondsToWait, consumer, builder);
        return sb.toString();
    }

    public void outputToConsumer(int secondsToWait, Consumer<CharSequence> consumer, CommandBuilder builder) {
        this.createProcess(builder, null, consumer, this.errorLine);
        this.waitNoError(secondsToWait);
    }

    public int waitForExit(int secondsToWait, CommandBuilder builder) {
        this.createProcess(builder, null, null, null);
        return this.waitForResult(secondsToWait);
    }
}

