/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

class ArtifactHelper {
    private final MavenProject project;
    private final Path composeSrc;
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final Map<String, String> artifactCoordinates = new HashMap<String, String>();

    static Optional<Path> findComposePath(Path directory) {
        return Stream.of("compose.yaml", "compose.yml", "compose.json").map(directory::resolve).filter(Files::isReadable).findFirst();
    }

    static DefaultArtifact composeArtifact(String dependency) {
        DefaultArtifact artifact = new DefaultArtifact(dependency);
        if ("".equals(artifact.getClassifier())) {
            return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "compose", "jar", artifact.getVersion());
        }
        return artifact;
    }

    static String namespacedPath(String namespace, Path path) {
        return namespace + "/" + String.valueOf(path.getFileName());
    }

    static void forEach(Collection<String> collection, DependencyConsumer consumer) throws MojoExecutionException, RepositoryException, IOException {
        if (collection != null) {
            SneakyDependencyConsumer sneaky = new SneakyDependencyConsumer(consumer);
            collection.stream().flatMap(ArtifactHelper::splitAndTrim).forEach(sneaky);
        }
    }

    private static Stream<String> splitAndTrim(String element) {
        return element == null ? Stream.of(new String[0]) : Stream.of(element.split("[,\\s]+")).map(String::trim).filter(i -> !i.isEmpty());
    }

    File fetchArtifact(Artifact artifact) throws ArtifactResolutionException, MojoExecutionException {
        Artifact local = this.repoSystem.resolveArtifact(this.repoSession, new ArtifactRequest(artifact, this.project.getRemoteProjectRepositories(), null)).getArtifact();
        if (local == null) {
            throw new MojoExecutionException(String.valueOf(artifact) + " is not available");
        }
        return local.getFile();
    }

    void processComposeSrc(Log log, PathConsumer pathConsumer) throws IOException {
        SneakyPathConsumer consumer = new SneakyPathConsumer(pathConsumer);
        log.debug((CharSequence)("processing " + String.valueOf(this.composeSrc)));
        Optional<Path> composeYaml = ArtifactHelper.findComposePath(this.composeSrc);
        composeYaml.ifPresent(path -> consumer.process("compose", this.project.getArtifactId(), (Path)path));
        try (DirectoryStream<Path> files = Files.newDirectoryStream(this.composeSrc, Files::isReadable);){
            for (Path dir : files) {
                log.debug((CharSequence)("processing " + String.valueOf(dir)));
                composeYaml = ArtifactHelper.findComposePath(dir);
                composeYaml.ifPresent(path -> {
                    String classifier = dir.getFileName().toString();
                    consumer.process(classifier, classifier, (Path)path);
                });
            }
        }
    }

    String coordinatesFromClassifier(String classifier) {
        return this.project.getGroupId() + ":" + this.project.getArtifactId() + ":jar:" + classifier + ":" + this.project.getVersion();
    }

    public Path jarPath(String classifier) throws IOException {
        return Files.createDirectories(Path.of(this.project.getBuild().getDirectory(), new String[0]), new FileAttribute[0]).resolve(this.project.getArtifactId() + "-" + this.project.getVersion() + "-" + classifier + ".jar");
    }

    public void addArtifact(Artifact artifact, AddArtifact handle) throws IOException, MojoExecutionException, RepositoryException {
        handle.addArtifact(this.lookup(artifact.toString()), this.fetchArtifact(artifact));
    }

    public void processArtifact(String gav, String name, InputStreamSupplier iss, ProcessArtifact handle) throws IOException {
        handle.processArtifact(this.lookup(gav), name, iss);
    }

    Coordinates lookup(String gav) {
        int colonIdx = gav.lastIndexOf(58);
        String key = gav.substring(0, colonIdx);
        String version = gav.substring(colonIdx + 1);
        return new Coordinates(gav, key, version, this.artifactCoordinates.put(key, version));
    }

    @Generated
    public ArtifactHelper(MavenProject project, Path composeSrc, RepositorySystem repoSystem, RepositorySystemSession repoSession) {
        this.project = project;
        this.composeSrc = composeSrc;
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
    }

    private static class SneakyDependencyConsumer
    implements Consumer<String> {
        private final DependencyConsumer dependencyConsumer;

        @Override
        public void accept(String dependency) {
            this.dependencyConsumer.addDependency(dependency);
        }

        @Generated
        public SneakyDependencyConsumer(DependencyConsumer dependencyConsumer) {
            this.dependencyConsumer = dependencyConsumer;
        }
    }

    @FunctionalInterface
    public static interface DependencyConsumer {
        public void addDependency(String var1) throws IOException, MojoExecutionException, RepositoryException;
    }

    private static class SneakyPathConsumer
    implements PathConsumer {
        private final PathConsumer pathConsumer;

        @Override
        public void process(String classifier, String namespace, Path composeYaml) {
            this.pathConsumer.process(classifier, namespace, composeYaml);
        }

        @Generated
        public SneakyPathConsumer(PathConsumer pathConsumer) {
            this.pathConsumer = pathConsumer;
        }
    }

    @FunctionalInterface
    static interface PathConsumer {
        public void process(String var1, String var2, Path var3) throws IOException, MojoExecutionException;
    }

    public record Coordinates(String gav, String key, String version, String prior) {
    }

    @FunctionalInterface
    public static interface AddArtifact {
        public void addArtifact(Coordinates var1, File var2) throws IOException, MojoExecutionException, RepositoryException;
    }

    @FunctionalInterface
    public static interface ProcessArtifact {
        public void processArtifact(Coordinates var1, String var2, InputStreamSupplier var3) throws IOException;
    }

    @FunctionalInterface
    public static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

