/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeProjectGoal;
import org.honton.chas.compose.maven.plugin.ExecHelper;

public abstract class ComposeLogsGoal
extends ComposeProjectGoal {
    @Parameter(property="compose.logs", defaultValue="${project.build.directory}/compose-logs", required=true)
    String logs;

    protected void saveServiceLogs(Path composeFile) throws IOException {
        CommandBuilder builder = this.createBuilder("ps").addGlobalOption("-f", composeFile.toString()).addOption("-a").addOption("--format", "{{.Service}}");
        this.saveLogs(new ExecHelper(this.getLog()).outputAsString(this.timeout, builder).split("\\s+"));
    }

    private void saveLogs(String[] services) throws IOException {
        Path logPath = this.relativeToCurrentDirectory(this.logs);
        Files.createDirectories(logPath, new FileAttribute[0]);
        for (String service : services) {
            CommandBuilder builder = this.createBuilder("logs").addOption("--no-log-prefix").addOption(service);
            Path output = logPath.resolve(service + ".log");
            try (BufferedWriter writer = Files.newBufferedWriter(output, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                Consumer<CharSequence> consumer = l -> {
                    try {
                        writer.append((CharSequence)l).append('\n');
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                };
                new ExecHelper(this.getLog()).outputToConsumer(this.timeout, consumer, builder);
            }
        }
    }
}

