/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;

public class SemVer
implements Comparable<SemVer> {
    private static final Pattern SEM_VER_EXACT = Pattern.compile("^(((0|[1-9][0-9]*)(\\.(0|[1-9][0-9]*))*)(-([0-9A-Za-z-.]*))?)(\\+([0-9A-Za-z-.]*))?$");
    private static final int ORDINAL_GROUP = 2;
    private static final int PRE_RELEASE_GROUP = 7;
    private static final int META_GROUP = 9;
    private static final Pattern PRE_RELEASE = Pattern.compile("(([1-9]\\d*)|([0-9A-Za-z-]+))\\.?");
    private static final int LEXICAL_GROUP = 1;
    private static final int NUMERIC_GROUP = 2;
    private final String version;
    private final int[] ordinals;
    private final String preRelease;
    private final String metadata;

    public static SemVer valueOf(String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = SEM_VER_EXACT.matcher(version);
        if (!matcher.find()) {
            throw new IllegalArgumentException(version + " is not a proper semantic version");
        }
        return new SemVer(matcher.group(0), SemVer.getOrdinals(matcher), matcher.group(7), matcher.group(9));
    }

    private static int[] getOrdinals(Matcher matcher) {
        String group = matcher.group(2);
        String[] segments = group.split("\\.");
        int[] ordinals = new int[segments.length];
        for (int i = 0; i < segments.length; ++i) {
            ordinals[i] = Integer.parseInt(segments[i]);
        }
        return ordinals;
    }

    private static int numberCompare(String leftField, String rightField) {
        if (leftField != null) {
            if (rightField == null) {
                return -1;
            }
            return Integer.parseInt(leftField) - Integer.parseInt(rightField);
        }
        if (rightField != null) {
            return 1;
        }
        return 0;
    }

    public int getMajor() {
        return this.ordinals[0];
    }

    public int getMinor() {
        return this.ordinals.length > 1 ? this.ordinals[1] : -1;
    }

    public int getPatch() {
        return this.ordinals.length > 2 ? this.ordinals[2] : -1;
    }

    public String toString() {
        return this.version;
    }

    @Override
    public int compareTo(@NonNull SemVer other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        for (int i = 0; i < this.ordinals.length && i != other.ordinals.length; ++i) {
            int diff = this.ordinals[i] - other.ordinals[i];
            if (diff == 0) continue;
            return diff;
        }
        if (this.ordinals.length != other.ordinals.length) {
            return this.ordinals.length - other.ordinals.length;
        }
        return this.preReleaseCompare(other);
    }

    private int preReleaseCompare(SemVer other) {
        if (this.preRelease == null) {
            return other.preRelease == null ? 0 : 1;
        }
        if (other.preRelease == null) {
            return -1;
        }
        Matcher a = PRE_RELEASE.matcher(this.preRelease);
        Matcher e = PRE_RELEASE.matcher(other.preRelease);
        while (a.find()) {
            if (!e.find()) {
                return 1;
            }
            int numberCmp = SemVer.numberCompare(a.group(2), e.group(2));
            if (numberCmp != 0) {
                return numberCmp;
            }
            int lexicalCmp = a.group(1).compareTo(e.group(1));
            if (lexicalCmp == 0) continue;
            return lexicalCmp;
        }
        return e.find() ? -1 : 0;
    }

    @Generated
    public int[] getOrdinals() {
        return this.ordinals;
    }

    @Generated
    public String getPreRelease() {
        return this.preRelease;
    }

    @Generated
    public String getMetadata() {
        return this.metadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemVer)) {
            return false;
        }
        SemVer other = (SemVer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SemVer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @Generated
    private SemVer(String version, int[] ordinals, String preRelease, String metadata) {
        this.version = version;
        this.ordinals = ordinals;
        this.preRelease = preRelease;
        this.metadata = metadata;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }
}

