/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.interpolation.AbstractValueSource;
import org.codehaus.plexus.interpolation.Interpolator;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.PropertiesBasedValueSource;
import org.codehaus.plexus.interpolation.StringSearchInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;

public final class InterpolatorFactory {
    private static PropertiesBasedValueSource sessionSource(MavenSession session) {
        File basedir = session.getRepositorySession().getLocalRepositoryManager().getRepository().getBasedir();
        Properties properties = new Properties();
        properties.setProperty("settings.localRepository", basedir.toString());
        properties.putAll((Map<?, ?>)session.getSystemProperties());
        properties.putAll((Map<?, ?>)session.getUserProperties());
        return new PropertiesBasedValueSource(properties);
    }

    private static PrefixedValueSourceWrapper envSource() {
        return new PrefixedValueSourceWrapper((ValueSource)new AbstractValueSource(false){

            public Object getValue(String expression) {
                return System.getenv(expression);
            }
        }, "env");
    }

    private static PrefixedValueSourceWrapper projectSource(MavenProject project) {
        return new PrefixedValueSourceWrapper((ValueSource)new ObjectBasedValueSource((Object)project), "project");
    }

    private static PrefixedValueSourceWrapper projectPropertiesSource(MavenProject project) {
        return new PrefixedValueSourceWrapper((ValueSource)new PropertiesBasedValueSource(project.getProperties()), "project.properties", true);
    }

    public static Interpolator createInterpolator(MavenSession session, MavenProject project) {
        StringSearchInterpolator interpolator = new StringSearchInterpolator();
        interpolator.setEscapeString("\\");
        interpolator.addValueSource((ValueSource)InterpolatorFactory.envSource());
        interpolator.addValueSource((ValueSource)InterpolatorFactory.sessionSource(session));
        interpolator.addValueSource((ValueSource)InterpolatorFactory.projectSource(project));
        interpolator.addValueSource((ValueSource)InterpolatorFactory.projectPropertiesSource(project));
        return interpolator;
    }

    @Generated
    private InterpolatorFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

