/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.honton.chas.compose.maven.plugin.ArtifactHelper;
import org.honton.chas.compose.maven.plugin.ComposeGoal;
import org.honton.chas.compose.maven.plugin.JarReader;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="assemble", defaultPhase=LifecyclePhase.COMPILE, threadSafe=true)
public class ComposeAssemble
extends ComposeGoal {
    @Parameter(property="compose.attach", defaultValue="true")
    boolean attach;
    @Parameter
    List<String> dependencies;
    @Parameter(property="compose.source", defaultValue="${project.basedir}/src/main/compose")
    String source;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Component
    RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Component
    MavenProjectHelper projectHelper;
    private ArtifactHelper artifactHelper;
    private Yaml yaml;
    private Map<String, ArtifactInfo> coordinatesToInfo;
    private Map<String, String> serviceToCoordinates;

    @Override
    protected final void doExecute() throws Exception {
        Path composeSrcPath = Path.of(this.source, new String[0]);
        if (Files.isDirectory(composeSrcPath, new LinkOption[0])) {
            this.yaml = new Yaml();
            this.artifactHelper = new ArtifactHelper(this.project, composeSrcPath, this.repoSystem, this.repoSession);
            this.coordinatesToInfo = new HashMap<String, ArtifactInfo>();
            this.serviceToCoordinates = new HashMap<String, String>();
            ArtifactHelper.forEach(this.dependencies, this::addDependency);
            this.artifactHelper.processComposeSrc(this.getLog(), this::readComposeFile);
            this.artifactHelper.processComposeSrc(this.getLog(), this::writeComposeJar);
            if (!this.coordinatesToInfo.isEmpty()) {
                return;
            }
        } else {
            this.getLog().warn((CharSequence)("Not a directory: " + String.valueOf(composeSrcPath)));
        }
        this.getLog().info((CharSequence)"No compose files found");
    }

    private void addDependency(String dependency) {
        DefaultArtifact artifact = ArtifactHelper.composeArtifact(dependency);
        this.artifactHelper.addArtifact((Artifact)artifact, this::addArtifact);
    }

    private void addArtifact(final ArtifactHelper.Coordinates nvp, File file) throws IOException, MojoExecutionException, RepositoryException {
        if (nvp.prior() != null) {
            throw new MojoExecutionException(nvp.gav() + " previously had version " + nvp.prior());
        }
        this.getLog().debug((CharSequence)("adding dependency " + nvp.key()));
        try (JarReader jr = new JarReader(file){

            @Override
            void process() throws IOException {
                if (this.isManifestEntry()) {
                    String[] services;
                    for (String service : services = this.extractMainAttributes("Services")) {
                        ComposeAssemble.this.serviceToCoordinates.put(service, nvp.gav());
                    }
                }
            }
        };){
            jr.visitEntries();
        }
    }

    void readComposeFile(String classifier, String namespace, Path composeYaml) throws IOException {
        List<ServiceInfo> serviceInfos;
        String contents = Files.readString(composeYaml);
        Map model = (Map)this.yaml.load(contents);
        String coordinates = this.artifactHelper.coordinatesFromClassifier(classifier);
        Object v = model.get("services");
        if (v instanceof Map) {
            Map services = (Map)v;
            serviceInfos = this.readServices(coordinates, services);
        } else {
            serviceInfos = List.of();
        }
        this.coordinatesToInfo.put(coordinates, new ArtifactInfo(coordinates, composeYaml, contents, serviceInfos));
    }

    private List<ServiceInfo> readServices(String coordinates, Map<?, ?> services) {
        ArrayList<ServiceInfo> serviceInfos = new ArrayList<ServiceInfo>();
        for (Map.Entry<?, ?> entries : services.entrySet()) {
            Map serviceExtends;
            Map service;
            Object obj = entries.getKey();
            if (!(obj instanceof String)) continue;
            String serviceName = (String)obj;
            obj = entries.getValue();
            if (!(obj instanceof Map) || !(service = (Map)obj).containsKey("image") && !service.containsKey("extends")) continue;
            String priorCoordinates = this.serviceToCoordinates.put(serviceName, coordinates);
            if (priorCoordinates != null) {
                if (priorCoordinates.equals(coordinates)) continue;
                this.getLog().error((CharSequence)("Service " + serviceName + " defined in " + coordinates + ", previously defined in " + priorCoordinates));
            }
            ArrayList<String> dependsOn = new ArrayList<String>();
            Object v = service.get("depends_on");
            if (v instanceof List) {
                List dependsOnList = (List)v;
                dependsOn.addAll(dependsOnList);
            } else {
                v = service.get("depends_on");
                if (v instanceof Map) {
                    Map dependsOnMap = (Map)v;
                    dependsOn.addAll(dependsOnMap.keySet());
                }
            }
            v = service.get("extends");
            if (v instanceof Map && (v = (serviceExtends = (Map)v).get("service")) instanceof String) {
                String dependentService = (String)v;
                dependsOn.add(dependentService);
            }
            this.getLog().debug((CharSequence)(serviceName + " depends on " + String.valueOf(dependsOn)));
            serviceInfos.add(new ServiceInfo(serviceName, dependsOn));
        }
        return serviceInfos;
    }

    private void writeComposeJar(String classifier, String namespace, Path composeYaml) throws IOException {
        Path destPath = this.artifactHelper.jarPath(classifier);
        ArtifactInfo info = this.coordinatesToInfo.get(this.artifactHelper.coordinatesFromClassifier(classifier));
        try (JarOutputStream destination = new JarOutputStream(Files.newOutputStream(destPath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), this.createManifest(info));){
            this.jarArtifact(info, destination, namespace, composeYaml.getParent());
        }
        if (this.attach) {
            this.getLog().debug((CharSequence)("attaching " + String.valueOf(destPath)));
            this.projectHelper.attachArtifact(this.project, "jar", classifier, destPath.toFile());
        }
    }

    private Manifest createManifest(ArtifactInfo info) {
        String dependencyCommaList;
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.put(Attributes.Name.CONTENT_TYPE, "Compose");
        mainAttributes.putValue("Created-By", "compose-maven-plugin");
        String services = info.serviceInfos.stream().map(ServiceInfo::serviceName).collect(Collectors.joining(","));
        if (!services.isEmpty()) {
            mainAttributes.putValue("Services", services);
        }
        if (!(dependencyCommaList = info.serviceInfos.stream().flatMap(si -> si.dependsOn.stream()).flatMap(this::serviceToCoordinates).filter(c -> !c.equals(info.coordinates)).collect(Collectors.joining(","))).isEmpty()) {
            mainAttributes.putValue("Dependencies", dependencyCommaList);
        }
        return manifest;
    }

    private Stream<String> serviceToCoordinates(String service) {
        String coordinates = this.serviceToCoordinates.get(service);
        if (coordinates == null) {
            this.getLog().warn((CharSequence)("Service " + service + " not found"));
        }
        return Stream.ofNullable(coordinates);
    }

    private void jarArtifact(ArtifactInfo info, JarOutputStream stream, String namespace, Path directory) throws IOException {
        try (DirectoryStream<Path> files = Files.newDirectoryStream(directory, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));){
            for (Path path : files) {
                this.jarFile(info, stream, namespace, path);
            }
        }
    }

    private void jarFile(ArtifactInfo info, JarOutputStream stream, String namespace, Path path) throws IOException {
        JarEntry entry = new JarEntry(ArtifactHelper.namespacedPath(namespace, path));
        entry.setTime(path.toFile().lastModified());
        stream.putNextEntry(entry);
        if (path.equals(info.composePath)) {
            stream.write(info.composeSpec.getBytes(StandardCharsets.UTF_8));
        } else {
            Files.copy(path, stream);
        }
        stream.closeEntry();
    }

    record ArtifactInfo(String coordinates, Path composePath, String composeSpec, List<ServiceInfo> serviceInfos) {
    }

    record ServiceInfo(String serviceName, List<String> dependsOn) {
    }
}

