/*
 * Decompiled with CFR 0.152.
 */
package org.honton.chas.compose.maven.plugin;

import java.nio.file.Path;
import org.apache.maven.plugins.annotations.Parameter;
import org.honton.chas.compose.maven.plugin.CommandBuilder;
import org.honton.chas.compose.maven.plugin.ComposeExecuteGoal;

public abstract class ComposeProjectGoal
extends ComposeExecuteGoal {
    public static final String COMPOSE_YAML = "compose.yaml";
    public static final String MOUNTS_YAML = "mounts.yaml";
    public static final String PORTS_YAML = "ports.yaml";
    public static final String DOT_ENV = ".env";
    @Parameter(property="compose.project", defaultValue="${project.artifactId}", required=true)
    String project;
    @Parameter(defaultValue="${project.build.directory}/compose", required=true, readonly=true)
    String composeProjectDir;
    Path composeProject;

    @Override
    protected CommandBuilder createBuilder(String subCommand) {
        this.composeProject = this.relativeToCurrentDirectory(this.composeProjectDir);
        return super.createBuilder(subCommand).addGlobalOption("--project-name", this.project);
    }

    protected Path relativeToCurrentDirectory(String dir) {
        return Path.of("", new String[0]).toAbsolutePath().relativize(Path.of(dir, new String[0]));
    }
}

